/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance;

import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.test.performance.ContinuousOpts;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceScope;
import org.apache.htrace.wrappers.TraceProxy;

public class ContinuousIngest {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static List<ColumnVisibility> visibilities;

    private static void initVisibilities(ContinuousOpts opts) throws Exception {
        String line;
        if (opts.visFile == null) {
            visibilities = Collections.singletonList(new ColumnVisibility());
            return;
        }
        visibilities = new ArrayList<ColumnVisibility>();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(opts.visFile)), StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            visibilities.add(new ColumnVisibility(line));
        }
        in.close();
    }

    private static ColumnVisibility getVisibility(Random rand) {
        return visibilities.get(rand.nextInt(visibilities.size()));
    }

    public static void main(String[] args) throws Exception {
        ContinuousOpts opts = new ContinuousOpts();
        TestOpts clientOpts = new TestOpts();
        try (TraceScope clientSpan = clientOpts.parseArgsAndTrace(ContinuousIngest.class.getName(), args, new Object[]{opts});){
            ContinuousIngest.initVisibilities(opts);
            if (opts.min < 0L || opts.max < 0L || opts.max <= opts.min) {
                throw new IllegalArgumentException("bad min and max");
            }
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(clientOpts.getClientProps()).build();){
                if (!client.tableOperations().exists(clientOpts.tableName)) {
                    throw new TableNotFoundException(null, clientOpts.tableName, "Consult the README and create the table before starting ingest.");
                }
                BatchWriter bw = client.createBatchWriter(clientOpts.tableName);
                bw = (BatchWriter)TraceProxy.trace((Object)bw, (Sampler)TraceUtil.countSampler((long)1024L));
                SecureRandom r = new SecureRandom();
                byte[] ingestInstanceId = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
                System.out.printf("UUID %d %s%n", System.currentTimeMillis(), new String(ingestInstanceId, StandardCharsets.UTF_8));
                long count = 0L;
                int flushInterval = 1000000;
                int maxDepth = 25;
                long[] prevRows = new long[1000000];
                long[] firstRows = new long[1000000];
                int[] firstColFams = new int[1000000];
                int[] firstColQuals = new int[1000000];
                long lastFlushTime = System.currentTimeMillis();
                block10: do {
                    Mutation m;
                    int index;
                    ColumnVisibility cv = ContinuousIngest.getVisibility(r);
                    for (index = 0; index < 1000000; ++index) {
                        long rowLong;
                        prevRows[index] = rowLong = ContinuousIngest.genLong(opts.min, opts.max, r);
                        firstRows[index] = rowLong;
                        int cf = r.nextInt(opts.maxColF);
                        int cq = r.nextInt(opts.maxColQ);
                        firstColFams[index] = cf;
                        firstColQuals[index] = cq;
                        m = ContinuousIngest.genMutation(rowLong, cf, cq, cv, ingestInstanceId, count, null, opts.checksum);
                        ++count;
                        bw.addMutation(m);
                    }
                    lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
                    if (count >= opts.num) break;
                    for (int depth = 1; depth < 25; ++depth) {
                        for (int index2 = 0; index2 < 1000000; ++index2) {
                            long rowLong = ContinuousIngest.genLong(opts.min, opts.max, r);
                            byte[] prevRow = ContinuousIngest.genRow(prevRows[index2]);
                            prevRows[index2] = rowLong;
                            m = ContinuousIngest.genMutation(rowLong, r.nextInt(opts.maxColF), r.nextInt(opts.maxColQ), cv, ingestInstanceId, count, prevRow, opts.checksum);
                            ++count;
                            bw.addMutation(m);
                        }
                        lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
                        if (count < opts.num) {
                            continue;
                        }
                        break block10;
                    }
                    for (index = 0; index < 999999; ++index) {
                        Mutation m2 = ContinuousIngest.genMutation(firstRows[index], firstColFams[index], firstColQuals[index], cv, ingestInstanceId, count, ContinuousIngest.genRow(prevRows[index + 1]), opts.checksum);
                        ++count;
                        bw.addMutation(m2);
                    }
                    lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
                } while (count < opts.num);
                bw.close();
            }
        }
    }

    private static long flush(BatchWriter bw, long count, int flushInterval, long lastFlushTime) throws MutationsRejectedException {
        long t1 = System.currentTimeMillis();
        bw.flush();
        long t2 = System.currentTimeMillis();
        System.out.printf("FLUSH %d %d %d %d %d%n", t2, t2 - lastFlushTime, t2 - t1, count, flushInterval);
        lastFlushTime = t2;
        return lastFlushTime;
    }

    public static Mutation genMutation(long rowLong, int cfInt, int cqInt, ColumnVisibility cv, byte[] ingestInstanceId, long count, byte[] prevRow, boolean checksum) {
        CRC32 cksum = null;
        byte[] rowString = ContinuousIngest.genRow(rowLong);
        byte[] cfString = FastFormat.toZeroPaddedString((long)cfInt, (int)4, (int)16, (byte[])EMPTY_BYTES);
        byte[] cqString = FastFormat.toZeroPaddedString((long)cqInt, (int)4, (int)16, (byte[])EMPTY_BYTES);
        if (checksum) {
            cksum = new CRC32();
            cksum.update(rowString);
            cksum.update(cfString);
            cksum.update(cqString);
            cksum.update(cv.getExpression());
        }
        Mutation m = new Mutation(new Text(rowString));
        m.put(new Text(cfString), new Text(cqString), cv, ContinuousIngest.createValue(ingestInstanceId, count, prevRow, cksum));
        return m;
    }

    public static final long genLong(long min, long max, Random r) {
        return (r.nextLong() & Long.MAX_VALUE) % (max - min) + min;
    }

    static final byte[] genRow(long min, long max, Random r) {
        return ContinuousIngest.genRow(ContinuousIngest.genLong(min, max, r));
    }

    static final byte[] genRow(long rowLong) {
        return FastFormat.toZeroPaddedString((long)rowLong, (int)16, (int)16, (byte[])EMPTY_BYTES);
    }

    private static Value createValue(byte[] ingestInstanceId, long count, byte[] prevRow, Checksum cksum) {
        int dataLen = ingestInstanceId.length + 16 + (prevRow == null ? 0 : prevRow.length) + 3;
        if (cksum != null) {
            dataLen += 8;
        }
        byte[] val = new byte[dataLen];
        System.arraycopy(ingestInstanceId, 0, val, 0, ingestInstanceId.length);
        int index = ingestInstanceId.length;
        val[index++] = 58;
        int added = FastFormat.toZeroPaddedString((byte[])val, (int)index, (long)count, (int)16, (int)16, (byte[])EMPTY_BYTES);
        if (added != 16) {
            throw new RuntimeException(" " + added);
        }
        index += 16;
        val[index++] = 58;
        if (prevRow != null) {
            System.arraycopy(prevRow, 0, val, index, prevRow.length);
            index += prevRow.length;
        }
        val[index++] = 58;
        if (cksum != null) {
            cksum.update(val, 0, index);
            cksum.getValue();
            FastFormat.toZeroPaddedString((byte[])val, (int)index, (long)cksum.getValue(), (int)8, (int)16, (byte[])EMPTY_BYTES);
        }
        return new Value(val);
    }

    static class TestOpts
    extends ClientOpts {
        @Parameter(names={"--table"}, description="table to use")
        String tableName = "ci";

        TestOpts() {
        }
    }
}

