/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@Deprecated
public class RowHash
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Text cq;
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(((Object)((Object)this)).getClass().getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        Opts opts = new Opts();
        opts.parseArgs(RowHash.class.getName(), args, new Object[0]);
        job.setInputFormatClass(AccumuloInputFormat.class);
        ClientConfiguration clientConf = ClientConfConverter.toClientConf((Properties)opts.getClientProps());
        AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConf);
        String principal = ClientProperty.AUTH_PRINCIPAL.getValue(opts.getClientProps());
        AuthenticationToken token = opts.getToken();
        AccumuloInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        AccumuloInputFormat.setInputTableName((Job)job, (String)opts.tableName);
        AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)opts.auths);
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)opts.tableName);
        String col = opts.column;
        int idx = col.indexOf(":");
        Text cf = new Text(idx < 0 ? col : col.substring(0, idx));
        Text text = cq = idx < 0 ? null : new Text(col.substring(idx + 1));
        if (cf.getLength() > 0) {
            AccumuloInputFormat.fetchColumns((Job)job, Collections.singleton(new Pair((Object)cf, (Object)cq)));
        }
        job.setMapperClass(HashDataMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RowHash(), (String[])args);
    }

    private static class Opts
    extends ClientOpts {
        @Parameter(names={"--column"}, required=true)
        String column;
        @Parameter(names={"-t", "--table"}, required=true, description="table to use")
        String tableName;

        private Opts() {
        }
    }

    public static class HashDataMapper
    extends Mapper<Key, Value, Text, Mutation> {
        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            Mutation m = new Mutation(row.getRow());
            m.put(new Text("cf-HASHTYPE"), new Text("cq-MD5BASE64"), new Value(Base64.getEncoder().encode(MD5Hash.digest((String)data.toString()).getDigest())));
            context.write(null, (Object)m);
            context.progress();
        }

        public void setup(Mapper.Context job) {
        }
    }
}

