/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.test.functional.CacheTestClean;
import org.apache.accumulo.test.functional.CacheTestReader;
import org.apache.accumulo.test.functional.CacheTestWriter;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZooCacheIT
extends ConfigurableMacBase {
    private static String pathName = "/zcTest-42";
    private static File testDir;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @BeforeClass
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public static void createTestDirectory() {
        testDir = new File(ZooCacheIT.createTestDir(ZooCacheIT.class.getName()), pathName);
        FileUtils.deleteQuietly((File)testDir);
        Assert.assertTrue((boolean)testDir.mkdir());
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((long)0L, (long)this.exec(CacheTestClean.class, pathName, testDir.getAbsolutePath()).waitFor());
        AtomicReference ref = new AtomicReference();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 3; ++i) {
            Thread reader = new Thread(() -> {
                try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
                    CacheTestReader.main(new String[]{pathName, testDir.getAbsolutePath(), ClientInfo.from((Properties)client.properties()).getZooKeepers()});
                }
                catch (Exception ex) {
                    ref.set(ex);
                }
            });
            reader.start();
            threads.add(reader);
        }
        Assert.assertEquals((long)0L, (long)this.exec(CacheTestWriter.class, pathName, testDir.getAbsolutePath(), "3", "50").waitFor());
        for (Thread t : threads) {
            t.join();
            if (ref.get() == null) continue;
            throw (Exception)ref.get();
        }
    }
}

