/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.test.performance.NullTserver;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZombieTServer {
    private static final Logger log = LoggerFactory.getLogger(ZombieTServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SecureRandom random = new SecureRandom();
        ((Random)random).setSeed(System.currentTimeMillis() % 1000L);
        int port = random.nextInt(30000) + 2000;
        ServerContext context = new ServerContext(new SiteConfiguration());
        TransactionWatcher watcher = new TransactionWatcher(context);
        final ThriftClientHandler tch = new ThriftClientHandler(context, watcher);
        TabletClientService.Processor processor = new TabletClientService.Processor((TabletClientService.Iface)tch);
        ServerAddress serverPort = TServerUtils.startTServer((MetricsSystem)Metrics.initSystem((String)ZombieTServer.class.getSimpleName()), (AccumuloConfiguration)context.getConfiguration(), (ThriftServerType)ThriftServerType.CUSTOM_HS_HA, (TProcessor)processor, (String)"ZombieTServer", (String)"walking dead", (int)2, (int)1, (long)1000L, (long)0xA00000L, null, null, (long)-1L, (HostAndPort[])new HostAndPort[]{HostAndPort.fromParts((String)"0.0.0.0", (int)port)});
        String addressString = serverPort.address.toString();
        String zPath = context.getZooKeeperRoot() + "/tservers" + "/" + addressString;
        ZooReaderWriter zoo = context.getZooReaderWriter();
        zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        ZooLock zlock = new ZooLock(zoo, zPath);
        ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void lostLock(ZooLock.LockLossReason reason) {
                try {
                    tch.halt(TraceUtil.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void unableToMonitorLockNode(Throwable e) {
                try {
                    tch.halt(TraceUtil.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }
        };
        byte[] lockContent = new ServerServices(addressString, ServerServices.Service.TSERV_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
        if (zlock.tryLock(lw, lockContent)) {
            log.debug("Obtained tablet server lock {}", (Object)zlock.getLockPath());
        }
        ThriftClientHandler thriftClientHandler = tch;
        synchronized (thriftClientHandler) {
            while (!tch.halted) {
                ((Object)((Object)tch)).wait();
            }
        }
        System.exit(0);
    }

    public static class ThriftClientHandler
    extends NullTserver.ThriftClientHandler {
        int statusCount = 0;
        boolean halted = false;

        ThriftClientHandler(ServerContext context, TransactionWatcher watcher) {
            super(context, watcher);
        }

        @Override
        public synchronized void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) {
            ThriftClientHandler thriftClientHandler = this;
            synchronized (thriftClientHandler) {
                if (this.statusCount++ < 1) {
                    TabletServerStatus result = new TabletServerStatus();
                    result.tableMap = new HashMap();
                    return result;
                }
            }
            UtilWaitThread.sleepUninterruptibly((long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.DAYS);
            return null;
        }

        @Override
        public synchronized void halt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            ((Object)((Object)this)).notifyAll();
        }
    }
}

