/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.HashMap;
import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.client.summary.summarizers.DeletesSummarizer;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.tserver.compaction.strategies.TooManyDeletesCompactionStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TooManyDeletesIT
extends AccumuloClusterHarness {
    @Test
    public void tooManyDeletesCompactionStrategyIT() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(TooManyDeletesIT.getClientProps()).build();){
            Mutation m;
            int i;
            String table = this.getUniqueNames(1)[0];
            SummarizerConfiguration sc = SummarizerConfiguration.builder(DeletesSummarizer.class).build();
            NewTableConfiguration ntc = new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{sc});
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_COMPACTION_STRATEGY.getKey(), TooManyDeletesCompactionStrategy.class.getName());
            props.put(Property.TABLE_COMPACTION_STRATEGY_PREFIX.getKey() + "threshold", ".25");
            props.put(Property.TABLE_MAJC_RATIO.getKey(), "10");
            ntc.setProperties(props);
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                for (int i2 = 0; i2 < 1000; ++i2) {
                    Mutation m2 = new Mutation((CharSequence)("row" + i2));
                    m2.put((CharSequence)"f", (CharSequence)"q", (CharSequence)("v" + i2));
                    bw.addMutation(m2);
                }
            }
            List summaries = c.tableOperations().summaries(table).flush(true).withConfiguration(new SummarizerConfiguration[]{sc}).retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            Summary summary = (Summary)summaries.get(0);
            Assert.assertEquals((long)1000L, (long)((Long)summary.getStatistics().get("total")));
            Assert.assertEquals((long)0L, (long)((Long)summary.getStatistics().get("deletes")));
            try (BatchWriter bw = c.createBatchWriter(table);){
                for (i = 0; i < 100; ++i) {
                    m = new Mutation((CharSequence)("row" + i));
                    m.putDelete((CharSequence)"f", (CharSequence)"q");
                    bw.addMutation(m);
                }
            }
            summaries = c.tableOperations().summaries(table).flush(true).withConfiguration(new SummarizerConfiguration[]{sc}).retrieve();
            Assert.assertEquals((long)1L, (long)summaries.size());
            summary = (Summary)summaries.get(0);
            Assert.assertEquals((long)1100L, (long)((Long)summary.getStatistics().get("total")));
            Assert.assertEquals((long)100L, (long)((Long)summary.getStatistics().get("deletes")));
            bw = c.createBatchWriter(table);
            try {
                for (i = 100; i < 300; ++i) {
                    m = new Mutation((CharSequence)("row" + i));
                    m.putDelete((CharSequence)"f", (CharSequence)"q");
                    bw.addMutation(m);
                }
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            c.tableOperations().flush(table, null, null, true);
            while (true) {
                summaries = c.tableOperations().summaries(table).flush(false).withConfiguration(new SummarizerConfiguration[]{sc}).retrieve();
                Assert.assertEquals((long)1L, (long)summaries.size());
                summary = (Summary)summaries.get(0);
                long total = (Long)summary.getStatistics().get("total");
                long deletes = (Long)summary.getStatistics().get("deletes");
                if (total == 700L && deletes == 0L) {
                    break;
                }
                UtilWaitThread.sleep((long)50L);
            }
        }
    }
}

