/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class})
public class TableIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Assume.assumeThat((Object)((Object)TableIT.getClusterType()), (Matcher)CoreMatchers.is((Object)((Object)AccumuloClusterHarness.ClusterType.MINI)));
        AccumuloCluster cluster = TableIT.getCluster();
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
        String rootPath = mac.getConfig().getDir().getAbsolutePath();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(TableIT.getClientProps()).build();){
            TableOperations to = c.tableOperations();
            String tableName = this.getUniqueNames(1)[0];
            to.create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(TableIT.getClientProps(), tableName);
            TestIngest.ingest(c, params);
            to.flush(tableName, null, null, true);
            VerifyIngest.verifyIngest(c, params);
            TableId id = TableId.of((String)((String)to.tableIdMap().get(tableName)));
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(new KeyExtent(id, null, null).toMetadataRange());
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                Assert.assertTrue((Iterators.size((Iterator)s.iterator()) > 0 ? 1 : 0) != 0);
                FileSystem fs = TableIT.getCluster().getFileSystem();
                Assert.assertTrue((fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length > 0 ? 1 : 0) != 0);
                to.delete(tableName);
                Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)s.iterator()));
                try {
                    Assert.assertEquals((long)0L, (long)fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                Assert.assertNull(to.tableIdMap().get(tableName));
                to.create(tableName);
                TestIngest.ingest(c, params);
                VerifyIngest.verifyIngest(c, params);
                to.delete(tableName);
            }
        }
    }
}

