/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BinaryIT;
import org.apache.accumulo.test.functional.BulkIT;
import org.apache.accumulo.test.functional.ConcurrencyIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ShutdownIT;
import org.apache.accumulo.test.mapreduce.MapReduceIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Test;

public class SslIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 360;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        super.configure(cfg, hadoopCoreSite);
        SslIT.configureForSsl(cfg, SslIT.getSslDir(SslIT.createTestDir(this.getClass().getName() + "_" + this.testName.getMethodName())));
    }

    @Test
    public void binary() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            BinaryIT.runTest(client, tableName);
        }
    }

    @Test
    public void concurrency() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ConcurrencyIT.runTest(client, this.getUniqueNames(1)[0]);
        }
    }

    @Test
    public void adminStop() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ShutdownIT.runAdminStopTest(client, this.getCluster());
        }
    }

    @Test
    public void bulk() throws Exception {
        Properties props = this.getClientProperties();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(props).build();){
            BulkIT.runTest(client, ClientInfo.from((Properties)props), this.cluster.getFileSystem(), new Path(this.getCluster().getConfig().getDir().getAbsolutePath(), "tmp"), this.getUniqueNames(1)[0], this.getClass().getName(), this.testName.getMethodName(), true);
        }
    }

    @Test
    public void mapReduce() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            MapReduceIT.runTest(client, this.getCluster());
        }
    }
}

