/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestRandomDeletes;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.Assert;
import org.junit.Test;

public class ShutdownIT
extends ConfigurableMacBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void shutdownDuringIngest() throws Exception {
        Process ingest = this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        ingest.destroy();
    }

    @Test
    public void shutdownDuringQuery() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor());
        Process verify = this.cluster.exec(VerifyIngest.class, new String[]{"-c", this.cluster.getClientPropsPath()}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        verify.destroy();
    }

    @Test
    public void shutdownDuringDelete() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor());
        Process deleter = this.cluster.exec(TestRandomDeletes.class, new String[]{"-c", this.cluster.getClientPropsPath()}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        deleter.destroy();
    }

    @Test
    public void shutdownDuringDeleteTable() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            for (int i = 0; i < 10; ++i) {
                c.tableOperations().create("table" + i);
            }
            AtomicReference ref = new AtomicReference();
            Thread async = new Thread(() -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        c.tableOperations().delete("table" + i);
                    }
                }
                catch (Exception ex) {
                    ref.set(ex);
                }
            });
            async.start();
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            if (ref.get() != null) {
                throw (Exception)ref.get();
            }
        }
    }

    @Test
    public void stopDuringStart() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
    }

    @Test
    public void adminStop() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ShutdownIT.runAdminStopTest(c, this.cluster);
        }
    }

    static void runAdminStopTest(AccumuloClient c, MiniAccumuloClusterImpl cluster) throws InterruptedException, IOException {
        int x = cluster.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor();
        Assert.assertEquals((long)0L, (long)x);
        List tabletServers = c.instanceOperations().getTabletServers();
        Assert.assertEquals((long)2L, (long)tabletServers.size());
        String doomed = (String)tabletServers.get(0);
        log.info("Stopping " + doomed);
        Assert.assertEquals((long)0L, (long)cluster.exec(Admin.class, new String[]{"stop", doomed}).getProcess().waitFor());
        tabletServers = c.instanceOperations().getTabletServers();
        Assert.assertEquals((long)1L, (long)tabletServers.size());
        Assert.assertNotEquals(tabletServers.get(0), (Object)doomed);
    }
}

