/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ScanSessionTimeOutIT;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBlockVerifyIT
extends ScanSessionTimeOutIT {
    private static final Logger log = LoggerFactory.getLogger(SessionBlockVerifyIT.class);
    ExecutorService service = Executors.newFixedThreadPool(10);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        cfg.setNumTservers(1);
        siteConfig.put(Property.TSERV_SESSION_MAXIDLE.getKey(), this.getMaxIdleTimeString());
        siteConfig.put(Property.TSERV_SCAN_EXECUTORS_DEFAULT_THREADS.getKey(), "11");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    protected String getMaxIdleTimeString() {
        return "1s";
    }

    @Override
    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SessionBlockVerifyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%08d", i)));
                    for (int j = 0; j < 3; ++j) {
                        m.put(new Text("cf1"), new Text("cq" + j), new Value((i + "_" + j).getBytes(StandardCharsets.UTF_8)));
                    }
                    bw.addMutation(m);
                }
            }
            try (Scanner scanner = c.createScanner(tableName, new Authorizations());){
                int i;
                scanner.setReadaheadThreshold(20000L);
                scanner.setRange(new Range((CharSequence)String.format("%08d", 0), (CharSequence)String.format("%08d", 1000)));
                IteratorSetting setting = new IteratorSetting(21, SlowIterator.class);
                SlowIterator.setSeekSleepTime(setting, Long.MAX_VALUE);
                SlowIterator.setSleepTime(setting, Long.MAX_VALUE);
                scanner.addScanIterator(setting);
                ArrayList<Future<Boolean>> callables = new ArrayList<Future<Boolean>>();
                CountDownLatch latch = new CountDownLatch(10);
                for (i = 0; i < 10; ++i) {
                    Future<Boolean> callable = this.service.submit(() -> {
                        Iterator slow = scanner.iterator();
                        latch.countDown();
                        while (slow.hasNext()) {
                            slow.next();
                        }
                        return slow.hasNext();
                    });
                    callables.add(callable);
                }
                latch.await();
                log.info("Starting SessionBlockVerifyIT");
                for (i = 0; i < 2; ++i) {
                    Scanner scanner2 = c.createScanner(tableName, new Authorizations());
                    scanner2.setRange(new Range((CharSequence)String.format("%08d", 0), (CharSequence)String.format("%08d", 1000)));
                    scanner2.setBatchSize(1);
                    Iterator iter = scanner2.iterator();
                    this.verify(iter, 0, 1000);
                }
                int sessionsFound = 0;
                String tserver = (String)Iterables.getOnlyElement((Iterable)c.instanceOperations().getTabletServers());
                List scans = c.instanceOperations().getActiveScans(tserver);
                for (ActiveScan activeScan : scans) {
                    if (!tableName.equals(activeScan.getTable()) || activeScan.getSsiList().size() <= 0) continue;
                    Assert.assertEquals((String)"Not the expected iterator", (long)1L, (long)activeScan.getSsiList().size());
                    Assert.assertTrue((String)"Not the expected iterator", (boolean)((String)activeScan.getSsiList().iterator().next()).contains("SlowIterator"));
                    ++sessionsFound;
                }
                Assert.assertEquals((String)"Must have ten sessions. Failure indicates a synchronization block within the sweep mechanism", (long)10L, (long)sessionsFound);
                for (Future future : callables) {
                    future.cancel(true);
                }
            }
            this.service.shutdown();
        }
    }
}

