/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.base.Stopwatch;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.Assert;
import org.junit.Test;

public class ScannerIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testScannerReadaheadConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerIT.getClientProps()).build();){
            Iterator iterator;
            Stopwatch sw;
            IteratorSetting cfg;
            c.tableOperations().create(table);
            try (BatchWriter bw = c.createBatchWriter(table);){
                Mutation m = new Mutation((CharSequence)"a");
                for (int i = 0; i < 10; ++i) {
                    m.put((CharSequence)Integer.toString(i), (CharSequence)"", (CharSequence)"");
                }
                bw.addMutation(m);
            }
            try (Scanner s = c.createScanner(table, new Authorizations());){
                cfg = new IteratorSetting(100, SlowIterator.class);
                SlowIterator.setSeekSleepTime(cfg, 100L);
                s.addScanIterator(cfg);
                s.setReadaheadThreshold(Long.MAX_VALUE);
                s.setBatchSize(1);
                s.setRange(new Range());
                sw = Stopwatch.createUnstarted();
                iterator = s.iterator();
                sw.start();
                while (iterator.hasNext()) {
                    sw.stop();
                    UtilWaitThread.sleep((long)100L);
                    iterator.next();
                    sw.start();
                }
                sw.stop();
            }
            long millisWithWait = sw.elapsed(TimeUnit.MILLISECONDS);
            try (Scanner s = c.createScanner(table, new Authorizations());){
                s.addScanIterator(cfg);
                s.setRange(new Range());
                s.setBatchSize(1);
                s.setReadaheadThreshold(0L);
                sw = Stopwatch.createUnstarted();
                iterator = s.iterator();
                sw.start();
                while (iterator.hasNext()) {
                    sw.stop();
                    UtilWaitThread.sleep((long)100L);
                    iterator.next();
                    sw.start();
                }
                sw.stop();
                long millisWithNoWait = sw.elapsed(TimeUnit.MILLISECONDS);
                Assert.assertTrue((String)("Expected less time to be taken with immediate readahead (" + millisWithNoWait + ") than without immediate readahead (" + millisWithWait + ")"), (millisWithNoWait < millisWithWait ? 1 : 0) != 0);
            }
        }
    }
}

