/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class RowDeleteIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RowDeleteIT.getClientProps()).build();){
            int count;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
            groups.put("lg1", Collections.singleton(new Text("foo")));
            c.tableOperations().setLocalityGroups(tableName, groups);
            IteratorSetting setting = new IteratorSetting(30, RowDeletingIterator.class);
            c.tableOperations().attachIterator(tableName, setting, EnumSet.of(IteratorUtil.IteratorScope.majc));
            c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "100");
            BatchWriter bw = c.createBatchWriter(tableName);
            bw.addMutation(FunctionalTestUtils.nm("r1", "foo", "cf1", "v1"));
            bw.addMutation(FunctionalTestUtils.nm("r1", "bar", "cf1", "v2"));
            bw.flush();
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                count = Iterators.size((Iterator)scanner.iterator());
                Assert.assertEquals((String)("count == " + count), (long)2L, (long)count);
                bw.addMutation(FunctionalTestUtils.nm("r1", "", "", RowDeletingIterator.DELETE_ROW_VALUE));
                bw.flush();
                c.tableOperations().flush(tableName, null, null, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 2, 2);
            }
            scanner = c.createScanner(tableName, Authorizations.EMPTY);
            try {
                count = Iterators.size((Iterator)scanner.iterator());
                Assert.assertEquals((String)("count == " + count), (long)3L, (long)count);
                c.tableOperations().compact(tableName, null, null, false, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            scanner = c.createScanner(tableName, Authorizations.EMPTY);
            try {
                count = Iterators.size((Iterator)scanner.iterator());
                Assert.assertEquals((String)("count == " + count), (long)0L, (long)count);
                bw.close();
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }
}

