/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(RestartIT.class);
    private ExecutorService svc;

    @Override
    public int defaultTimeoutSeconds() {
        return 600;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Before
    public void setup() {
        this.svc = Executors.newFixedThreadPool(1);
    }

    @After
    public void teardown() throws Exception {
        if (this.svc == null) {
            return;
        }
        if (!this.svc.isShutdown()) {
            this.svc.shutdown();
        }
        while (!this.svc.awaitTermination(10L, TimeUnit.SECONDS)) {
            log.info("Waiting for threadpool to terminate");
        }
    }

    @Test
    public void restartMaster() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            Future<Integer> ret = this.svc.submit(() -> {
                try {
                    return control.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--rows", "" + params.rows, "--table", tableName});
                }
                catch (IOException e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            });
            control.stopAllServers(ServerType.MASTER);
            control.startAllServers(ServerType.MASTER);
            Assert.assertEquals((long)0L, (long)ret.get().intValue());
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void restartMasterRecovery() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            byte[] masterLockData;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            control.stopAllServers(ServerType.MASTER);
            control.stopAllServers(ServerType.TRACER);
            control.stopAllServers(ServerType.TABLET_SERVER);
            control.stopAllServers(ServerType.GARBAGE_COLLECTOR);
            control.stopAllServers(ServerType.MONITOR);
            ClientInfo info = ClientInfo.from((Properties)c.properties());
            ZooReader zreader = new ZooReader(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
            ZooCache zcache = new ZooCache(zreader, null);
            do {
                if ((masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((String)c.instanceOperations().getInstanceID()) + "/masters/lock"), null)) == null) continue;
                log.info("Master lock is still held");
                Thread.sleep(1000L);
            } while (masterLockData != null);
            cluster.start();
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
            control.stopAllServers(ServerType.MASTER);
            masterLockData = new byte[]{};
            do {
                if ((masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((String)c.instanceOperations().getInstanceID()) + "/masters/lock"), null)) == null) continue;
                log.info("Master lock is still held");
                Thread.sleep(1000L);
            } while (masterLockData != null);
            cluster.start();
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void restartMasterSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            byte[] masterLockData;
            String tableName = this.getUniqueNames(1)[0];
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "5K");
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            Future<Integer> ret = this.svc.submit(() -> {
                try {
                    return control.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--rows", "" + params.rows, "--table", tableName});
                }
                catch (Exception e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            });
            control.stopAllServers(ServerType.MASTER);
            ClientInfo info = ClientInfo.from((Properties)c.properties());
            ZooReader zreader = new ZooReader(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
            ZooCache zcache = new ZooCache(zreader, null);
            do {
                if ((masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((String)c.instanceOperations().getInstanceID()) + "/masters/lock"), null)) == null) continue;
                log.info("Master lock is still held");
                Thread.sleep(1000L);
            } while (masterLockData != null);
            cluster.start();
            Assert.assertEquals((long)0L, (long)ret.get().intValue());
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void killedTabletServer() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            cluster.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            cluster.start();
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void killedTabletServer2() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String[] names = this.getUniqueNames(2);
            String tableName = names[0];
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            c.tableOperations().create(tableName);
            control.stopAllServers(ServerType.TABLET_SERVER);
            cluster.start();
            c.tableOperations().create(names[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void killedTabletServerDuringShutdown() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            TestIngest.IngestParams params = new TestIngest.IngestParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            try {
                RestartIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                RestartIT.getCluster().getClusterControl().adminStopAll();
            }
            finally {
                RestartIT.getCluster().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownDuringCompactingSplitting() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
            String splitThreshold = null;
            for (Map.Entry entry : c.tableOperations().getProperties(tableName)) {
                if (!((String)entry.getKey()).equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) continue;
                splitThreshold = (String)entry.getValue();
                break;
            }
            Assert.assertNotNull(splitThreshold);
            try {
                c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "20K");
                TestIngest.ingest(c, params);
                c.tableOperations().flush(tableName, null, null, false);
                VerifyIngest.verifyIngest(c, params);
                RestartIT.getCluster().stop();
            }
            finally {
                if (RestartIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
                    RestartIT.getCluster().start();
                    c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), splitThreshold);
                }
            }
        }
    }
}

