/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.master.balancer.RegexGroupBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class RegexGroupBalanceIT
extends ConfigurableMacBase {
    @Override
    public void beforeClusterStart(MiniAccumuloConfigImpl cfg) {
        cfg.setNumTservers(4);
    }

    @Test(timeout=120000L)
    public void testBalancing() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            boolean allGood;
            Table<String, String, MutableInt> groupLocationCounts;
            String tablename = this.getUniqueNames(1)[0];
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("01a"));
            splits.add(new Text("01m"));
            splits.add(new Text("01z"));
            splits.add(new Text("02a"));
            splits.add(new Text("02f"));
            splits.add(new Text("02r"));
            splits.add(new Text("02z"));
            splits.add(new Text("03a"));
            splits.add(new Text("03f"));
            splits.add(new Text("03m"));
            splits.add(new Text("03r"));
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(RegexGroupBalancer.REGEX_PROPERTY, "(\\d\\d).*");
            props.put(RegexGroupBalancer.DEFAUT_GROUP_PROPERTY, "03");
            props.put(RegexGroupBalancer.WAIT_TIME_PROPERTY, "50ms");
            props.put(Property.TABLE_LOAD_BALANCER.getKey(), RegexGroupBalancer.class.getName());
            client.tableOperations().create(tablename, new NewTableConfiguration().setProperties(props).withSplits(splits));
            do {
                Thread.sleep(250L);
                groupLocationCounts = this.getCounts(client, tablename);
                allGood = true;
                allGood &= this.checkGroup(groupLocationCounts, "01", 1, 1, 3);
                allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
                allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
            } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 3, 3, 4)));
            splits.clear();
            splits.add(new Text("01b"));
            splits.add(new Text("01f"));
            splits.add(new Text("01l"));
            splits.add(new Text("01r"));
            client.tableOperations().addSplits(tablename, splits);
            do {
                Thread.sleep(250L);
                groupLocationCounts = this.getCounts(client, tablename);
                allGood = true;
                allGood &= this.checkGroup(groupLocationCounts, "01", 1, 2, 4);
                allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
                allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
            } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 4, 4, 4)));
            client.tableOperations().merge(tablename, null, new Text("01z"));
            do {
                Thread.sleep(250L);
                groupLocationCounts = this.getCounts(client, tablename);
                allGood = true;
                allGood &= this.checkGroup(groupLocationCounts, "01", 1, 1, 1);
                allGood &= this.checkGroup(groupLocationCounts, "02", 1, 1, 4);
                allGood &= this.checkGroup(groupLocationCounts, "03", 1, 2, 4);
            } while (!(allGood &= this.checkTabletsPerTserver(groupLocationCounts, 2, 3, 4)));
        }
    }

    private boolean checkTabletsPerTserver(Table<String, String, MutableInt> groupLocationCounts, int minTabletPerTserver, int maxTabletsPerTserver, int totalTservser) {
        for (Map groups : groupLocationCounts.columnMap().values()) {
            int sum = 0;
            for (MutableInt mi : groups.values()) {
                sum += mi.intValue();
            }
            if (sum >= minTabletPerTserver && sum <= maxTabletsPerTserver) continue;
            return false;
        }
        return groupLocationCounts.columnKeySet().size() == totalTservser;
    }

    private boolean checkGroup(Table<String, String, MutableInt> groupLocationCounts, String group, int min, int max, int tsevers) {
        Collection counts = groupLocationCounts.row((Object)group).values();
        if (counts.size() == 0) {
            return min == 0 && max == 0 && tsevers == 0;
        }
        return min == ((MutableInt)Collections.min(counts)).intValue() && max == ((MutableInt)Collections.max(counts)).intValue() && counts.size() == tsevers;
    }

    private Table<String, String, MutableInt> getCounts(AccumuloClient client, String tablename) throws TableNotFoundException {
        try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tablename)));
            s.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            HashBasedTable groupLocationCounts = HashBasedTable.create();
            for (Map.Entry entry : s) {
                String loc;
                String group = ((Key)entry.getKey()).getRow().toString();
                group = group.endsWith("<") ? "03" : group.substring(tableId.canonical().length() + 1).substring(0, 2);
                MutableInt count = (MutableInt)groupLocationCounts.get((Object)group, (Object)(loc = new TServerInstance((Value)entry.getValue(), ((Key)entry.getKey()).getColumnQualifier()).toString()));
                if (count == null) {
                    count = new MutableInt(0);
                    groupLocationCounts.put((Object)group, (Object)loc, (Object)count);
                }
                count.increment();
            }
            Iterator iterator = groupLocationCounts;
            return iterator;
        }
    }
}

