/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.rfile.CreateEmpty;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryWithEmptyRFileIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(RecoveryWithEmptyRFileIT.class);
    private static final int ROWS = 200000;
    private static final int COLS = 1;

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
    }

    @Test
    public void replaceMissingRFile() throws Exception {
        log.info("Ingest some data, verify it was stored properly, replace an underlying rfile with an empty one and verify we can scan.");
        Properties props = this.getClientProperties();
        ClientInfo info = ClientInfo.from((Properties)props);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(props).build();){
            String tableName = this.getUniqueNames(1)[0];
            ReadWriteIT.ingest(client, info, 200000, 1, 50, 0, tableName);
            ReadWriteIT.verify(client, info, 200000, 1, 50, 0, tableName);
            client.tableOperations().flush(tableName, null, null, true);
            client.tableOperations().offline(tableName, true);
            log.debug("Replacing rfile(s) with empty");
            try (Scanner meta = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                String tableId = (String)client.tableOperations().tableIdMap().get(tableName);
                meta.setRange(new Range(new Text(tableId + ";"), new Text(tableId + "<")));
                meta.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                boolean foundFile = false;
                for (Map.Entry entry : meta) {
                    foundFile = true;
                    Path rfile = new Path(((Key)entry.getKey()).getColumnQualifier().toString());
                    log.debug("Removing rfile '{}'", (Object)rfile);
                    this.cluster.getFileSystem().delete(rfile, false);
                    Process processInfo = this.cluster.exec(CreateEmpty.class, new String[]{rfile.toString()}).getProcess();
                    Assert.assertEquals((long)0L, (long)processInfo.waitFor());
                }
                Assert.assertTrue((boolean)foundFile);
            }
            log.trace("invalidate cached file handles by issuing a compaction");
            client.tableOperations().online(tableName, true);
            client.tableOperations().compact(tableName, null, null, false, true);
            log.debug("make sure we can still scan");
            try (Scanner scan = client.createScanner(tableName, Authorizations.EMPTY);){
                scan.setRange(new Range());
                long cells = 0L;
                for (Map.Entry entry : scan) {
                    if (entry == null) continue;
                    ++cells;
                }
                Assert.assertEquals((long)0L, (long)cells);
            }
        }
    }
}

