/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.standalone.StandaloneAccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestMultiTableIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.categories.StandaloneCapableClusterTests;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StandaloneCapableClusterTests.class, SunnyDayTests.class})
public class ReadWriteIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteIT.class);
    static final int ROWS = 100000;
    static final int COLS = 1;
    static final String COLF = "colf";

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 360;
    }

    @Test(expected=RuntimeException.class)
    public void invalidInstanceName() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().to((CharSequence)"fake_instance_name", (CharSequence)cluster.getZooKeepers()).as((CharSequence)ReadWriteIT.getAdminPrincipal(), ReadWriteIT.getAdminToken()).build();){
            client.instanceOperations().getTabletServers();
        }
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="path provided by test; url provided by test")
    public void sunnyDay() throws Exception {
        log.debug("Starting Monitor");
        cluster.getClusterControl().startAllServers(ServerType.MONITOR);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            byte[] masterLockData;
            String monitorSslKeystore;
            String tableName = this.getUniqueNames(1)[0];
            ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 100000, 1, 50, 0, tableName);
            ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 100000, 1, 50, 0, tableName);
            String monitorLocation = null;
            while (monitorLocation == null) {
                monitorLocation = MonitorUtil.getLocation((ClientContext)((ClientContext)accumuloClient));
                if (monitorLocation != null) continue;
                log.debug("Could not fetch monitor HTTP address from zookeeper");
                Thread.sleep(2000L);
            }
            String scheme = "http://";
            if (ReadWriteIT.getCluster() instanceof StandaloneAccumuloCluster && (monitorSslKeystore = ReadWriteIT.getCluster().getSiteConfiguration().get(Property.MONITOR_SSL_KEYSTORE.getKey())) != null && !monitorSslKeystore.isEmpty()) {
                log.info("Using HTTPS since monitor ssl keystore configuration was observed in accumulo configuration");
                scheme = "https://";
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                TrustManager[] tm = new TrustManager[]{new TestTrustManager()};
                ctx.init(new KeyManager[0], tm, new SecureRandom());
                SSLContext.setDefault(ctx);
                HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new TestHostnameVerifier());
            }
            URL url = new URL(scheme + monitorLocation);
            log.debug("Fetching web page {}", (Object)url);
            String result = FunctionalTestUtils.readAll(url.openStream());
            Assert.assertTrue((result.length() > 100 ? 1 : 0) != 0);
            log.debug("Stopping accumulo cluster");
            ClusterControl control = cluster.getClusterControl();
            control.adminStopAll();
            ClientInfo info = ClientInfo.from((Properties)accumuloClient.properties());
            ZooReader zreader = new ZooReader(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
            ZooCache zcache = new ZooCache(zreader, null);
            do {
                if ((masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((String)accumuloClient.instanceOperations().getInstanceID()) + "/masters/lock"), null)) == null) continue;
                log.info("Master lock is still held");
                Thread.sleep(1000L);
            } while (masterLockData != null);
            control.stopAllServers(ServerType.GARBAGE_COLLECTOR);
            control.stopAllServers(ServerType.MONITOR);
            control.stopAllServers(ServerType.TRACER);
            log.debug("success!");
            cluster.start();
        }
    }

    public static void ingest(AccumuloClient accumuloClient, ClientInfo info, int rows, int cols, int width, int offset, String tableName) throws Exception {
        ReadWriteIT.ingest(accumuloClient, info, rows, cols, width, offset, COLF, tableName);
    }

    public static void ingest(AccumuloClient accumuloClient, ClientInfo info, int rows, int cols, int width, int offset, String colf, String tableName) throws Exception {
        TestIngest.IngestParams params = new TestIngest.IngestParams(info.getProperties(), tableName, rows);
        params.cols = cols;
        params.dataSize = width;
        params.startRow = offset;
        params.columnFamily = colf;
        params.createTable = true;
        TestIngest.ingest(accumuloClient, params);
    }

    public static void verify(AccumuloClient accumuloClient, ClientInfo info, int rows, int cols, int width, int offset, String tableName) throws Exception {
        ReadWriteIT.verify(accumuloClient, info, rows, cols, width, offset, COLF, tableName);
    }

    private static void verify(AccumuloClient accumuloClient, ClientInfo info, int rows, int cols, int width, int offset, String colf, String tableName) throws Exception {
        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(info.getProperties(), tableName, rows);
        params.rows = rows;
        params.dataSize = width;
        params.startRow = offset;
        params.columnFamily = colf;
        params.cols = cols;
        VerifyIngest.verifyIngest(accumuloClient, params);
    }

    public static String[] args(String ... args) {
        return args;
    }

    @Test
    public void multiTableTest() throws Exception {
        ClusterControl control = cluster.getClusterControl();
        String prefix = this.getClass().getSimpleName() + "_" + this.testName.getMethodName();
        ExecutorService svc = Executors.newFixedThreadPool(2);
        Future<Integer> p1 = svc.submit(() -> {
            try {
                return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "-c", cluster.getClientPropsPath(), "--tablePrefix", prefix));
            }
            catch (IOException e) {
                log.error("Error running MultiTableIngest", (Throwable)e);
                return -1;
            }
        });
        Future<Integer> p2 = svc.submit(() -> {
            try {
                return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "--readonly", "-c", cluster.getClientPropsPath(), "--tablePrefix", prefix));
            }
            catch (IOException e) {
                log.error("Error running MultiTableIngest", (Throwable)e);
                return -1;
            }
        });
        svc.shutdown();
        while (!svc.isTerminated()) {
            svc.awaitTermination(15L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((long)0L, (long)p1.get().intValue());
        Assert.assertEquals((long)0L, (long)p2.get().intValue());
    }

    @Test
    public void largeTest() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 2, 1, 500000, 0, table);
            ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 2, 1, 500000, 0, table);
        }
    }

    @Test
    public void interleaved() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            ReadWriteIT.interleaveTest(accumuloClient, tableName);
        }
    }

    static void interleaveTest(AccumuloClient accumuloClient, String tableName) throws Exception {
        int i;
        AtomicBoolean fail = new AtomicBoolean(false);
        int CHUNKSIZE = 10000;
        ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 10000, 1, 50, 0, tableName);
        for (i = 0; i < 100000; i += 10000) {
            int start = i;
            Thread verify = new Thread(() -> {
                try {
                    ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 10000, 1, 50, start, tableName);
                }
                catch (Exception ex) {
                    fail.set(true);
                }
            });
            verify.start();
            ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 10000, 1, 50, i + 10000, tableName);
            verify.join();
            Assert.assertFalse((boolean)fail.get());
        }
        ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 10000, 1, 50, i, tableName);
    }

    public static Text t(String s) {
        return new Text(s);
    }

    public static Mutation m(String row, String cf, String cq, String value) {
        Mutation m = new Mutation(ReadWriteIT.t(row));
        m.put(ReadWriteIT.t(cf), ReadWriteIT.t(cq), new Value(value.getBytes()));
        return m;
    }

    @Test
    public void localityGroupPerf() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            accumuloClient.tableOperations().create(tableName);
            accumuloClient.tableOperations().setProperty(tableName, "table.group.g1", COLF);
            accumuloClient.tableOperations().setProperty(tableName, "table.groups.enabled", "g1");
            ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 2000, 1, 50, 0, tableName);
            accumuloClient.tableOperations().compact(tableName, null, null, true, true);
            try (BatchWriter bw = accumuloClient.createBatchWriter(tableName);){
                bw.addMutation(ReadWriteIT.m("zzzzzzzzzzz", "colf2", "cq", "value"));
            }
            long now = System.currentTimeMillis();
            try (Scanner scanner = accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
                scanner.fetchColumnFamily(new Text(COLF));
                Iterators.size((Iterator)scanner.iterator());
            }
            long diff = System.currentTimeMillis() - now;
            now = System.currentTimeMillis();
            try (Scanner scanner = accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
                scanner.fetchColumnFamily(new Text("colf2"));
                Iterators.size((Iterator)scanner.iterator());
            }
            long diff2 = System.currentTimeMillis() - now;
            Assert.assertTrue((diff2 < diff ? 1 : 0) != 0);
        }
    }

    @Test
    public void sunnyLG() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            accumuloClient.tableOperations().create(tableName);
            TreeMap<String, Set<Text>> groups = new TreeMap<String, Set<Text>>();
            groups.put("g1", Collections.singleton(ReadWriteIT.t(COLF)));
            accumuloClient.tableOperations().setLocalityGroups(tableName, groups);
            this.verifyLocalityGroupsInRFile(accumuloClient, tableName);
        }
    }

    @Test
    public void sunnyLGUsingNewTableConfiguration() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
            groups.put("g1", Collections.singleton(ReadWriteIT.t(COLF)));
            ntc.setLocalityGroups(groups);
            accumuloClient.tableOperations().create(tableName, ntc);
            this.verifyLocalityGroupsInRFile(accumuloClient, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyLocalityGroupsInRFile(AccumuloClient accumuloClient, String tableName) throws Exception {
        ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 2000, 1, 50, 0, tableName);
        ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 2000, 1, 50, 0, tableName);
        accumuloClient.tableOperations().flush(tableName, null, null, true);
        try (BatchScanner bscanner = accumuloClient.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 1);){
            String tableId = (String)accumuloClient.tableOperations().tableIdMap().get(tableName);
            bscanner.setRanges(Collections.singletonList(new Range(new Text(tableId + ";"), new Text(tableId + "<"))));
            bscanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            boolean foundFile = false;
            for (Map.Entry entry : bscanner) {
                foundFile = true;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream oldOut = System.out;
                try (PrintStream newOut = new PrintStream(baos);){
                    System.setOut(newOut);
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    args.add("--props");
                    args.add(ReadWriteIT.getCluster().getAccumuloPropertiesPath());
                    if (ReadWriteIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE && ReadWriteIT.saslEnabled()) {
                        args.add("--config");
                        StandaloneAccumuloCluster sac = (StandaloneAccumuloCluster)cluster;
                        String hadoopConfDir = sac.getHadoopConfDir();
                        args.add(new Path(hadoopConfDir, "core-site.xml").toString());
                        args.add(new Path(hadoopConfDir, "hdfs-site.xml").toString());
                    }
                    log.info("Invoking PrintInfo with {}", args);
                    PrintInfo.main((String[])args.toArray(new String[args.size()]));
                    newOut.flush();
                    String stdout = baos.toString();
                    Assert.assertTrue((boolean)stdout.contains("Locality group           : g1"));
                    Assert.assertTrue((boolean)stdout.contains("families        : [colf]"));
                }
                finally {
                    System.setOut(oldOut);
                }
            }
            Assert.assertTrue((boolean)foundFile);
        }
    }

    @Test
    public void localityGroupChange() throws Exception {
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ReadWriteIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            TableOperations to = accumuloClient.tableOperations();
            to.create(table);
            String[] config = new String[]{"lg1:colf", null, "lg1:colf,xyz", "lg1:colf,xyz;lg2:c1,c2"};
            int i = 0;
            for (String cfg : config) {
                to.setLocalityGroups(table, this.getGroups(cfg));
                ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 100000 * (i + 1), 1, 50, 100000 * i, table);
                to.flush(table, null, null, true);
                ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 0, 1, 50, 100000 * (i + 1), table);
                ++i;
            }
            to.delete(table);
            to.create(table);
            config = new String[]{"lg1:colf", null, "lg1:colf,xyz", "lg1:colf;lg2:colf"};
            i = 1;
            for (String cfg : config) {
                ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 100000 * i, 1, 50, 0, table);
                ReadWriteIT.ingest(accumuloClient, ReadWriteIT.getClientInfo(), 100000 * i, 1, 50, 0, "xyz", table);
                to.setLocalityGroups(table, this.getGroups(cfg));
                to.flush(table, null, null, true);
                ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 100000 * i, 1, 50, 0, table);
                ReadWriteIT.verify(accumuloClient, ReadWriteIT.getClientInfo(), 100000 * i, 1, 50, 0, "xyz", table);
                ++i;
            }
        }
    }

    private Map<String, Set<Text>> getGroups(String cfg) {
        TreeMap<String, Set<Text>> groups = new TreeMap<String, Set<Text>>();
        if (cfg != null) {
            for (String group : cfg.split(";")) {
                String[] parts = group.split(":");
                HashSet<Text> cols = new HashSet<Text>();
                for (String col : parts[1].split(",")) {
                    cols.add(ReadWriteIT.t(col));
                }
                groups.put(parts[1], cols);
            }
        }
        return groups;
    }

    @SuppressFBWarnings(value={"WEAK_HOSTNAME_VERIFIER"}, justification="okay for test")
    private static class TestHostnameVerifier
    implements HostnameVerifier {
        private TestHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="trust manager is okay for testing")
    private static class TestTrustManager
    implements X509TrustManager {
        private TestTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

