/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientExec;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ManagerApiIT
extends SharedMiniClusterBase {
    private static Credentials rootUser;
    private static Credentials regularUser;
    private static Credentials privilegedUser;
    private Function<TCredentials, ClientExec<MasterClientService.Client>> op;

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        SharedMiniClusterBase.startMiniCluster();
        rootUser = new Credentials(ManagerApiIT.getPrincipal(), ManagerApiIT.getToken());
        regularUser = new Credentials("regularUser", (AuthenticationToken)new PasswordToken((CharSequence)"regularUser"));
        privilegedUser = new Credentials("privilegedUser", (AuthenticationToken)new PasswordToken((CharSequence)"privilegedUser"));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            SecurityOperations rootSecOps = client.securityOperations();
            for (Credentials user : Arrays.asList(regularUser, privilegedUser)) {
                rootSecOps.createLocalUser(user.getPrincipal(), (PasswordToken)user.getToken());
            }
            rootSecOps.grantSystemPermission(privilegedUser.getPrincipal(), SystemPermission.SYSTEM);
        }
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testPermissions_setMasterGoalState() throws Exception {
        this.op = user -> client -> client.setMasterGoalState(null, user, MasterGoalState.NORMAL);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void testPermissions_initiateFlush() throws Exception {
        String tableId;
        String[] uniqNames = this.getUniqueNames(3);
        String tableName = uniqNames[0];
        Credentials regUserWithWrite = new Credentials(uniqNames[1], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[1]));
        Credentials regUserWithAlter = new Credentials(uniqNames[2], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[2]));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            SecurityOperations rootSecOps = client.securityOperations();
            rootSecOps.createLocalUser(regUserWithWrite.getPrincipal(), (PasswordToken)regUserWithWrite.getToken());
            rootSecOps.createLocalUser(regUserWithAlter.getPrincipal(), (PasswordToken)regUserWithAlter.getToken());
            client.tableOperations().create(tableName);
            rootSecOps.grantTablePermission(regUserWithWrite.getPrincipal(), tableName, TablePermission.WRITE);
            rootSecOps.grantTablePermission(regUserWithAlter.getPrincipal(), tableName, TablePermission.ALTER_TABLE);
            tableId = (String)client.tableOperations().tableIdMap().get(tableName);
        }
        this.op = user -> client -> client.initiateFlush(null, user, tableId);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionDenied(this.op, privilegedUser);
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithWrite);
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithAlter);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
    }

    @Test
    public void testPermissions_waitForFlush() throws Exception {
        String tableId;
        String[] uniqNames = this.getUniqueNames(3);
        String tableName = uniqNames[0];
        Credentials regUserWithWrite = new Credentials(uniqNames[1], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[1]));
        Credentials regUserWithAlter = new Credentials(uniqNames[2], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[2]));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            SecurityOperations rootSecOps = client.securityOperations();
            rootSecOps.createLocalUser(regUserWithWrite.getPrincipal(), (PasswordToken)regUserWithWrite.getToken());
            rootSecOps.createLocalUser(regUserWithAlter.getPrincipal(), (PasswordToken)regUserWithAlter.getToken());
            client.tableOperations().create(tableName);
            rootSecOps.grantTablePermission(regUserWithWrite.getPrincipal(), tableName, TablePermission.WRITE);
            rootSecOps.grantTablePermission(regUserWithAlter.getPrincipal(), tableName, TablePermission.ALTER_TABLE);
            tableId = (String)client.tableOperations().tableIdMap().get(tableName);
        }
        AtomicLong flushId = new AtomicLong();
        this.op = user -> client -> flushId.set(client.initiateFlush(null, user, tableId));
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = user -> client -> client.waitForFlush(null, user, tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionDenied(this.op, privilegedUser);
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithWrite);
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithAlter);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
    }

    @Test
    public void testPermissions_setSystemProperty() throws Exception {
        String propKey = Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey();
        this.op = user -> client -> client.setSystemProperty(null, user, propKey, "10000");
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            client.instanceOperations().removeProperty(propKey);
        }
    }

    @Test
    public void testPermissions_removeSystemProperty() throws Exception {
        String propKey1 = Property.GC_CYCLE_DELAY.getKey();
        String propKey2 = Property.GC_CYCLE_START.getKey();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            client.instanceOperations().setProperty(propKey1, "10000");
            client.instanceOperations().setProperty(propKey2, "10000");
        }
        this.op = user -> client -> client.removeSystemProperty(null, user, propKey1);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = user -> client -> client.removeSystemProperty(null, user, propKey2);
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void testPermissions_shutdownTabletServer() throws Exception {
        String fakeHostAndPort = this.getUniqueNames(1)[0] + ":0";
        this.op = user -> client -> client.shutdownTabletServer(null, user, fakeHostAndPort, false);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void z99_testPermissions_shutdown() throws Exception {
        this.op = user -> client -> client.shutdown(null, user, false);
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    private static void expectPermissionSuccess(Function<TCredentials, ClientExec<MasterClientService.Client>> op, Credentials user) throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).as((CharSequence)user.getPrincipal(), user.getToken()).build();){
            ClientContext context = (ClientContext)client;
            MasterClient.executeVoid((ClientContext)context, op.apply(context.rpcCreds()));
        }
    }

    private static void expectPermissionDenied(Function<TCredentials, ClientExec<MasterClientService.Client>> op, Credentials user) throws Exception {
        AccumuloSecurityException e = (AccumuloSecurityException)Assert.assertThrows(AccumuloSecurityException.class, () -> ManagerApiIT.expectPermissionSuccess(op, user));
        Assert.assertSame((Object)SecurityErrorCode.PERMISSION_DENIED, (Object)e.getSecurityErrorCode());
    }
}

