/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class HalfDeadTServerIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.GENERAL_RPC_TIMEOUT, "5s");
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.FALSE.toString());
        cfg.useMiniDFS(true);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void testRecover() throws Exception {
        this.test(10);
    }

    @Test
    public void testTimeout() throws Exception {
        String results = this.test(20, true);
        if (results != null && !results.contains("Session expired")) {
            log.info("Failed to find 'Session expired' in output, but TServer did die which is expected");
        }
    }

    public String test(int seconds) throws Exception {
        return this.test(seconds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION"}, justification="path provided by test; command args provided by test")
    public String test(int seconds, boolean expectTserverDied) throws Exception {
        if (!this.makeDiskFailureLibrary()) {
            return null;
        }
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String string;
            DumpOutput t;
            Process tserver;
            block33: {
                while (c.instanceOperations().getTabletServers().isEmpty()) {
                    Thread.sleep(50L);
                }
                String javaHome = System.getProperty("java.home");
                String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
                String classpath = System.getProperty("java.class.path");
                classpath = new File(this.cluster.getConfig().getDir(), "conf") + File.pathSeparator + classpath;
                String className = TabletServer.class.getName();
                ArrayList<String> argList = new ArrayList<String>();
                argList.addAll(Arrays.asList(javaBin, "-cp", classpath));
                argList.addAll(Arrays.asList(Main.class.getName(), className));
                ProcessBuilder builder = new ProcessBuilder(argList);
                Map<String, String> env = builder.environment();
                env.put("ACCUMULO_HOME", this.cluster.getConfig().getDir().getAbsolutePath());
                env.put("ACCUMULO_LOG_DIR", this.cluster.getConfig().getLogDir().getAbsolutePath());
                String trickFilename = this.cluster.getConfig().getLogDir().getAbsolutePath() + "/TRICK_FILE";
                env.put("TRICK_FILE", trickFilename);
                String libPath = System.getProperty("user.dir") + "/target/fake_disk_failure.so";
                env.put("LD_PRELOAD", libPath);
                env.put("DYLD_INSERT_LIBRARIES", libPath);
                env.put("DYLD_FORCE_FLAT_NAMESPACE", "true");
                Process ingest = null;
                tserver = builder.start();
                t = new DumpOutput(tserver.getInputStream());
                try {
                    t.start();
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    this.cluster.killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    c.tableOperations().create("test_ingest");
                    Assert.assertEquals((long)1L, (long)c.instanceOperations().getTabletServers().size());
                    int rows = 100000;
                    ingest = this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--rows", rows + ""}).getProcess();
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    File trickFile = new File(trickFilename);
                    try {
                        Assert.assertTrue((boolean)trickFile.createNewFile());
                        UtilWaitThread.sleepUninterruptibly((long)seconds, (TimeUnit)TimeUnit.SECONDS);
                    }
                    finally {
                        if (!trickFile.delete()) {
                            log.error("Couldn't delete {}", (Object)trickFile);
                        }
                    }
                    if (seconds <= 10) {
                        Assert.assertEquals((long)0L, (long)ingest.waitFor());
                        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(this.getClientProperties());
                        params.rows = rows;
                        VerifyIngest.verifyIngest(c, params);
                    } else {
                        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
                        tserver.waitFor();
                        t.join();
                        tserver = null;
                    }
                    String results = t.toString();
                    Assert.assertTrue((boolean)results.contains("sleeping\nsleeping\nsleeping\n"));
                    string = results;
                    if (ingest == null) break block33;
                    ingest.destroy();
                }
                catch (Throwable throwable) {
                    if (ingest != null) {
                        ingest.destroy();
                        ingest.waitFor();
                    }
                    if (tserver != null) {
                        try {
                            if (expectTserverDied) {
                                try {
                                    tserver.exitValue();
                                }
                                catch (IllegalThreadStateException e) {
                                    Assert.fail((String)"Expected TServer to kill itself, but it is still running");
                                }
                            }
                        }
                        finally {
                            tserver.destroy();
                            tserver.waitFor();
                            t.join();
                        }
                    }
                    throw throwable;
                }
                ingest.waitFor();
            }
            if (tserver != null) {
                try {
                    if (expectTserverDied) {
                        try {
                            tserver.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            Assert.fail((String)"Expected TServer to kill itself, but it is still running");
                        }
                    }
                }
                finally {
                    tserver.destroy();
                    tserver.waitFor();
                    t.join();
                }
            }
            return string;
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="command executed is not from user input")
    private boolean makeDiskFailureLibrary() throws Exception {
        String root = System.getProperty("user.dir");
        String source = root + "/src/test/c/fake_disk_failure.c";
        String lib = root + "/target/fake_disk_failure.so";
        String platform = System.getProperty("os.name");
        String[] cmd = platform.equals("Darwin") ? new String[]{"gcc", "-arch", "x86_64", "-arch", "i386", "-dynamiclib", "-O3", "-fPIC", source, "-o", lib} : new String[]{"gcc", "-D_GNU_SOURCE", "-Wall", "-fPIC", source, "-shared", "-o", lib, "-ldl"};
        Process gcc = Runtime.getRuntime().exec(cmd);
        return gcc.waitFor() == 0;
    }

    class DumpOutput
    extends Daemon {
        private final BufferedReader rdr;
        private final StringBuilder output;

        DumpOutput(InputStream is) {
            this.rdr = new BufferedReader(new InputStreamReader(is));
            this.output = new StringBuilder();
        }

        public void run() {
            try {
                String line;
                while ((line = this.rdr.readLine()) != null) {
                    System.out.println(line);
                    this.output.append(line);
                    this.output.append("\n");
                }
            }
            catch (IOException ex) {
                ConfigurableMacBase.log.error("IOException", (Throwable)ex);
            }
        }

        public String toString() {
            return this.output.toString();
        }
    }
}

