/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class DurabilityIT
extends ConfigurableMacBase {
    static final long N = 100000L;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
    }

    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    private String[] init(AccumuloClient c) throws Exception {
        String[] tableNames = this.getUniqueNames(4);
        TableOperations tableOps = c.tableOperations();
        this.createTable(c, tableNames[0]);
        this.createTable(c, tableNames[1]);
        this.createTable(c, tableNames[2]);
        this.createTable(c, tableNames[3]);
        tableOps.setProperty(tableNames[1], Property.TABLE_DURABILITY.getKey(), "flush");
        tableOps.setProperty(tableNames[2], Property.TABLE_DURABILITY.getKey(), "log");
        tableOps.setProperty(tableNames[3], Property.TABLE_DURABILITY.getKey(), "none");
        return tableNames;
    }

    private void cleanup(AccumuloClient c, String[] tableNames) throws Exception {
        for (String tableName : tableNames) {
            c.tableOperations().delete(tableName);
        }
    }

    private void createTable(AccumuloClient c, String tableName) throws Exception {
        c.tableOperations().create(tableName);
    }

    @Test(timeout=240000L)
    public void testSync() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[0], 100000L);
            this.restartTServer();
            Assert.assertEquals((long)100000L, (long)this.readSome(client, tableNames[0]));
            this.cleanup(client, tableNames);
        }
    }

    @Test(timeout=240000L)
    public void testFlush() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[1], 100000L);
            this.restartTServer();
            Assert.assertEquals((long)100000L, (long)this.readSome(client, tableNames[1]));
            this.cleanup(client, tableNames);
        }
    }

    @Test(timeout=240000L)
    public void testLog() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[2], 100000L);
            this.restartTServer();
            long numResults = this.readSome(client, tableNames[2]);
            Assert.assertTrue((String)("Expected 100000 >= " + numResults), (numResults <= 100000L ? 1 : 0) != 0);
            this.cleanup(client, tableNames);
        }
    }

    @Test(timeout=240000L)
    public void testNone() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[3], 100000L);
            this.restartTServer();
            long numResults = this.readSome(client, tableNames[3]);
            Assert.assertTrue((String)("Expected 100000 >= " + numResults), (numResults <= 100000L ? 1 : 0) != 0);
            this.cleanup(client, tableNames);
        }
    }

    @Test(timeout=240000L)
    public void testIncreaseDurability() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "none");
            this.writeSome(c, tableName, 100000L);
            this.restartTServer();
            long numResults = this.readSome(c, tableName);
            Assert.assertTrue((String)("Expected 100000 >= " + numResults), (numResults <= 100000L ? 1 : 0) != 0);
            c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "sync");
            this.writeSome(c, tableName, 100000L);
            this.restartTServer();
            Assert.assertEquals((long)100000L, (long)this.readSome(c, tableName));
        }
    }

    private static Map<String, String> map(Iterable<Map.Entry<String, String>> entries) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Test(timeout=240000L)
    public void testMetaDurability() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.instanceOperations().setProperty(Property.TABLE_DURABILITY.getKey(), "none");
            Map<String, String> props = DurabilityIT.map(c.tableOperations().getProperties(MetadataTable.NAME));
            Assert.assertEquals((Object)"sync", (Object)props.get(Property.TABLE_DURABILITY.getKey()));
            c.tableOperations().create(tableName);
            props = DurabilityIT.map(c.tableOperations().getProperties(tableName));
            Assert.assertEquals((Object)"none", (Object)props.get(Property.TABLE_DURABILITY.getKey()));
            this.restartTServer();
            Assert.assertTrue((boolean)c.tableOperations().exists(tableName));
        }
    }

    private long readSome(AccumuloClient client, String table) throws Exception {
        return Iterators.size((Iterator)client.createScanner(table, Authorizations.EMPTY).iterator());
    }

    private void restartTServer() throws Exception {
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.start();
    }

    private void writeSome(AccumuloClient c, String table, long count) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(table);){
            int i = 1;
            while ((long)i < count + 1L) {
                Mutation m = new Mutation((CharSequence)("" + i));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
                if ((long)i % Math.max(1L, count / 100L) == 0L) {
                    bw.flush();
                }
                ++i;
            }
        }
    }
}

