/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(CompactionIT.class);
    private String majcThreadMaxOpen;
    private String majcDelay;
    private String majcMaxConcurrent;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN, "4");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.TSERV_MAJC_MAXCONCURRENT, "1");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void alterConfig() throws Exception {
        if (CompactionIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionIT.getClientProps()).build();){
                InstanceOperations iops = client.instanceOperations();
                Map config = iops.getSystemConfiguration();
                this.majcThreadMaxOpen = (String)config.get(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey());
                this.majcDelay = (String)config.get(Property.TSERV_MAJC_DELAY.getKey());
                this.majcMaxConcurrent = (String)config.get(Property.TSERV_MAJC_MAXCONCURRENT.getKey());
                iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), "4");
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1");
                iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), "1");
                CompactionIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                CompactionIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
        }
    }

    @After
    public void resetConfig() throws Exception {
        if (this.majcThreadMaxOpen != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionIT.getClientProps()).build();){
                InstanceOperations iops = client.instanceOperations();
                iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), this.majcThreadMaxOpen);
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
                iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), this.majcMaxConcurrent);
                CompactionIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                CompactionIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(CompactionIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1.0");
            FileSystem fs = CompactionIT.getFileSystem();
            Path root = new Path(fs.getUri().toString() + cluster.getTemporaryPath(), this.getClass().getName());
            fs.deleteOnExit(root);
            Path testrf = new Path(root, "testrf");
            fs.deleteOnExit(testrf);
            FunctionalTestUtils.createRFiles(c, fs, testrf.toString(), 500000, 59, 4);
            c.tableOperations().importDirectory(testrf.toString()).to(tableName).load();
            int beforeCount = this.countFiles(c);
            AtomicBoolean fail = new AtomicBoolean(false);
            int THREADS = 5;
            for (int count = 0; count < 5; ++count) {
                ExecutorService executor = Executors.newFixedThreadPool(5);
                int span = 8474;
                for (int i = 0; i < 500000; i += 8474) {
                    int finalI = i;
                    Runnable r = () -> {
                        try {
                            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(CompactionIT.getClientProps(), tableName, 8474);
                            params.startRow = finalI;
                            params.random = 56;
                            params.dataSize = 50;
                            params.cols = 1;
                            VerifyIngest.verifyIngest(c, params);
                        }
                        catch (Exception ex) {
                            log.warn("Got exception verifying data", (Throwable)ex);
                            fail.set(true);
                        }
                    };
                    executor.execute(r);
                }
                executor.shutdown();
                executor.awaitTermination(this.defaultTimeoutSeconds(), TimeUnit.SECONDS);
                Assert.assertFalse((String)"Failed to successfully run all threads, Check the test output for error", (boolean)fail.get());
            }
            int finalCount = this.countFiles(c);
            Assert.assertTrue((finalCount < beforeCount ? 1 : 0) != 0);
            try {
                CompactionIT.getClusterControl().adminStopAll();
            }
            finally {
                CompactionIT.getCluster().stop();
                if (CompactionIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
                    CompactionIT.getCluster().start();
                }
            }
        }
    }

    private int countFiles(AccumuloClient c) throws Exception {
        try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.fetchColumnFamily(new Text(MetadataSchema.TabletsSection.TabletColumnFamily.NAME));
            s.fetchColumnFamily(new Text(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME));
            int n = Iterators.size((Iterator)s.iterator());
            return n;
        }
    }
}

