/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class CombinerIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private void checkSum(String tableName, AccumuloClient c) throws Exception {
        try (Scanner s = c.createScanner(tableName, Authorizations.EMPTY);){
            Iterator i = s.iterator();
            Assert.assertTrue((boolean)i.hasNext());
            Map.Entry entry = (Map.Entry)i.next();
            Assert.assertEquals((Object)"45", (Object)((Value)entry.getValue()).toString());
            Assert.assertFalse((boolean)i.hasNext());
        }
    }

    @Test
    public void aggregationTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(CombinerIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            IteratorSetting setting = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column("cf")));
            c.tableOperations().attachIterator(tableName, setting);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 10; ++i) {
                    Mutation m = new Mutation((CharSequence)"row1");
                    m.put("cf".getBytes(), "col1".getBytes(), ("" + i).getBytes());
                    bw.addMutation(m);
                }
            }
            this.checkSum(tableName, c);
        }
    }
}

