/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.LoadPlan;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BulkNewIT
extends SharedMiniClusterBase {
    private String tableName;
    private AccumuloConfiguration aconf;
    private FileSystem fs;
    private String rootPath;

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new Callback());
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Before
    public void setupBulkTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(this.tableName);
            this.aconf = BulkNewIT.getCluster().getServerContext().getConfiguration();
            this.fs = BulkNewIT.getCluster().getFileSystem();
            this.rootPath = BulkNewIT.getCluster().getTemporaryPath().toString();
        }
    }

    private String getDir(String testName) throws Exception {
        String dir = this.rootPath + testName + this.getUniqueNames(1)[0];
        this.fs.delete(new Path(dir), true);
        return dir;
    }

    private void testSingleTabletSingleFile(AccumuloClient c, boolean offline, boolean setTime) throws Exception {
        this.addSplits(c, this.tableName, "0333");
        if (offline) {
            c.tableOperations().offline(this.tableName);
        }
        String dir = this.getDir("/testSingleTabletSingleFileNoSplits-");
        String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 332);
        c.tableOperations().importDirectory(dir).to(this.tableName).tableTime(setTime).load();
        if (offline) {
            c.tableOperations().online(this.tableName);
        }
        this.verifyData(c, this.tableName, 0, 332, setTime);
        this.verifyMetadata(c, this.tableName, (Map<String, Set<String>>)ImmutableMap.of((Object)"0333", (Object)ImmutableSet.of((Object)h1), (Object)"null", (Object)ImmutableSet.of()));
    }

    @Test
    public void testSingleTabletSingleFile() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFile(client, false, false);
        }
    }

    @Test
    public void testSetTime() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.tableName = "testSetTime_table1";
            NewTableConfiguration newTableConf = new NewTableConfiguration();
            newTableConf.setTimeType(TimeType.LOGICAL);
            client.tableOperations().create(this.tableName, newTableConf);
            this.testSingleTabletSingleFile(client, false, true);
        }
    }

    @Test
    public void testSingleTabletSingleFileOffline() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFile(client, true, false);
        }
    }

    private void testSingleTabletSingleFileNoSplits(AccumuloClient c, boolean offline) throws Exception {
        if (offline) {
            c.tableOperations().offline(this.tableName);
        }
        String dir = this.getDir("/testSingleTabletSingleFileNoSplits-");
        String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
        c.tableOperations().importDirectory(dir).to(this.tableName).load();
        if (offline) {
            c.tableOperations().online(this.tableName);
        }
        this.verifyData(c, this.tableName, 0, 333, false);
        this.verifyMetadata(c, this.tableName, (Map<String, Set<String>>)ImmutableMap.of((Object)"null", (Object)ImmutableSet.of((Object)h1)));
    }

    @Test
    public void testSingleTabletSingleFileNoSplits() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFileNoSplits(client, false);
        }
    }

    @Test
    public void testSingleTabletSingleFileNoSplitsOffline() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFileNoSplits(client, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadPermissions() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333");
            String dir = this.getDir("/testBadPermissions-");
            this.writeData(dir + "/f1.", this.aconf, 0, 333);
            Path rFilePath = new Path(dir, "f1.rf");
            FsPermission originalPerms = this.fs.getFileStatus(rFilePath).getPermission();
            this.fs.setPermission(rFilePath, FsPermission.valueOf((String)"----------"));
            try {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof FileNotFoundException) && !(cause.getCause() instanceof FileNotFoundException)) {
                    Assert.fail((String)("Expected FileNotFoundException but threw " + e.getCause()));
                }
            }
            finally {
                this.fs.setPermission(rFilePath, originalPerms);
            }
            originalPerms = this.fs.getFileStatus(new Path(dir)).getPermission();
            this.fs.setPermission(new Path(dir), FsPermission.valueOf((String)"dr--r--r--"));
            try {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
            }
            catch (AccumuloException ae) {
                if (!(ae.getCause() instanceof FileNotFoundException)) {
                    Assert.fail((String)("Expected FileNotFoundException but threw " + ae.getCause()));
                }
            }
            finally {
                this.fs.setPermission(new Path(dir), originalPerms);
            }
        }
    }

    private void testBulkFile(boolean offline, boolean usePlan) throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333 0666 0999 1333 1666");
            if (offline) {
                c.tableOperations().offline(this.tableName);
            }
            String dir = this.getDir("/testBulkFile-");
            HashMap<String, Set<String>> hashes = new HashMap<String, Set<String>>();
            for (String endRow : Arrays.asList("0333 0666 0999 1333 1666 null".split(" "))) {
                hashes.put(endRow, new HashSet());
            }
            FSDataOutputStream out = this.fs.create(new Path(dir, "junk"));
            out.writeChars("ABCDEFG\n");
            out.close();
            String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
            ((Set)hashes.get("0333")).add(h1);
            String h2 = this.writeData(dir + "/f2.", this.aconf, 334, 999);
            ((Set)hashes.get("0666")).add(h2);
            ((Set)hashes.get("0999")).add(h2);
            String h3 = this.writeData(dir + "/f3.", this.aconf, 1000, 1499);
            ((Set)hashes.get("1333")).add(h3);
            ((Set)hashes.get("1666")).add(h3);
            String h4 = this.writeData(dir + "/f4.", this.aconf, 1500, 1999);
            ((Set)hashes.get("1666")).add(h4);
            ((Set)hashes.get("null")).add(h4);
            if (usePlan) {
                LoadPlan loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, (CharSequence)BulkNewIT.row(333), (CharSequence)BulkNewIT.row(999)).loadFileTo("f3.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1000), (CharSequence)BulkNewIT.row(1499)).loadFileTo("f4.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1500), (CharSequence)BulkNewIT.row(1999)).build();
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
            } else {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
            }
            if (offline) {
                c.tableOperations().online(this.tableName);
            }
            this.verifyData(c, this.tableName, 0, 1999, false);
            this.verifyMetadata(c, this.tableName, hashes);
        }
    }

    @Test
    public void testBulkFile() throws Exception {
        this.testBulkFile(false, false);
    }

    @Test
    public void testBulkFileOffline() throws Exception {
        this.testBulkFile(true, false);
    }

    @Test
    public void testLoadPlan() throws Exception {
        this.testBulkFile(false, true);
    }

    @Test
    public void testLoadPlanOffline() throws Exception {
        this.testBulkFile(true, true);
    }

    @Test
    public void testBadLoadPlans() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333 0666 0999 1333 1666");
            String dir = this.getDir("/testBulkFile-");
            this.writeData(dir + "/f1.", this.aconf, 0, 333);
            this.writeData(dir + "/f2.", this.aconf, 0, 666);
            LoadPlan loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(666)).loadFileTo("f3.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(666)).build();
            try {
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).build();
            try {
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(555)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(555)).build();
            try {
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
                Assert.fail();
            }
            catch (AccumuloException accumuloException) {
                // empty catch block
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyDir() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            String dir = this.getDir("/testBulkFile-");
            FileSystem fs = BulkNewIT.getCluster().getFileSystem();
            fs.mkdirs(new Path(dir));
            c.tableOperations().importDirectory(dir).to(this.tableName).load();
        }
    }

    private void addSplits(AccumuloClient client, String tableName, String splitString) throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String split : splitString.split(" ")) {
            splits.add(new Text(split));
        }
        client.tableOperations().addSplits(tableName, splits);
    }

    private void verifyData(AccumuloClient client, String table, int start, int end, boolean setTime) throws Exception {
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            Iterator iter = scanner.iterator();
            for (int i = start; i <= end; ++i) {
                if (!iter.hasNext()) {
                    throw new Exception("row " + i + " not found");
                }
                Map.Entry entry = (Map.Entry)iter.next();
                String row = String.format("%04d", i);
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                    throw new Exception("unexpected row " + entry.getKey() + " " + i);
                }
                if (Integer.parseInt(((Value)entry.getValue()).toString()) != i) {
                    throw new Exception("unexpected value " + entry + " " + i);
                }
                if (!setTime) continue;
                Assert.assertEquals((long)1L, (long)((Key)entry.getKey()).getTimestamp());
            }
            if (iter.hasNext()) {
                throw new Exception("found more than expected " + iter.next());
            }
        }
    }

    private void verifyMetadata(AccumuloClient client, String tableName, Map<String, Set<String>> expectedHashes) {
        HashSet<String> endRowsSeen = new HashSet<String>();
        String id = (String)client.tableOperations().tableIdMap().get(tableName);
        try (TabletsMetadata tablets = TabletsMetadata.builder().forTable(TableId.of((String)id)).fetchFiles().fetchLoaded().fetchPrev().build(client);){
            for (TabletMetadata tablet : tablets) {
                Assert.assertTrue((boolean)tablet.getLoaded().isEmpty());
                Set fileHashes = tablet.getFiles().stream().map(f -> this.hash((String)f)).collect(Collectors.toSet());
                String endRow = tablet.getEndRow() == null ? "null" : tablet.getEndRow().toString();
                Assert.assertEquals(expectedHashes.get(endRow), fileHashes);
                endRowsSeen.add(endRow);
            }
            Assert.assertEquals(expectedHashes.keySet(), endRowsSeen);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "WEAK_MESSAGE_DIGEST_SHA1"}, justification="path provided by test; sha-1 is okay for test")
    private String hash(String filename) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(filename.replaceFirst("^file:", ""), new String[0]));
            byte[] hash = MessageDigest.getInstance("SHA1").digest(data);
            return new BigInteger(1, hash).toString(16);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String row(int r) {
        return String.format("%04d", r);
    }

    private String writeData(String file, AccumuloConfiguration aconf, int s, int e) throws Exception {
        FileSystem fs = BulkNewIT.getCluster().getFileSystem();
        String filename = file + "rf";
        try (FileSKVWriter writer = FileOperations.getInstance().newWriterBuilder().forFile(filename, fs, fs.getConf(), CryptoServiceFactory.newDefaultInstance()).withTableConfiguration(aconf).build();){
            writer.startDefaultLocalityGroup();
            for (int i = s; i <= e; ++i) {
                writer.append(new Key(new Text(BulkNewIT.row(i))), new Value(Integer.toString(i).getBytes(StandardCharsets.UTF_8)));
            }
        }
        return this.hash(filename);
    }

    private static class Callback
    implements MiniClusterConfigurationCallback {
        private Callback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration conf) {
            cfg.setMemory(ServerType.TABLET_SERVER, 512L, MemoryUnit.MEGABYTE);
            conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
        }
    }
}

