/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.MasterClient;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class BalanceAfterCommsFailureIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GENERAL_RPC_TIMEOUT, "2s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create("test");
            Collection tservers = (Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER);
            ArrayList<Integer> tserverPids = new ArrayList<Integer>(tservers.size());
            for (ProcessReference tserver : tservers) {
                Process p = tserver.getProcess();
                if (!p.getClass().getName().equals("java.lang.UNIXProcess")) {
                    log.info("Found process that was not UNIXProcess, exiting test");
                    return;
                }
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                tserverPids.add(f.getInt(p));
            }
            Iterator iterator = tserverPids.iterator();
            while (iterator.hasNext()) {
                int pid = (Integer)iterator.next();
                Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"kill", "-SIGSTOP", Integer.toString(pid)}).waitFor());
            }
            UtilWaitThread.sleep((long)20000L);
            iterator = tserverPids.iterator();
            while (iterator.hasNext()) {
                int pid = (Integer)iterator.next();
                Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"kill", "-SIGCONT", Integer.toString(pid)}).waitFor());
            }
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String split : "a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")) {
                splits.add(new Text(split));
            }
            c.tableOperations().addSplits("test", splits);
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)c.createScanner("test", Authorizations.EMPTY)));
            UtilWaitThread.sleep((long)30000L);
            this.checkBalance(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBalance(AccumuloClient c) throws Exception {
        ClientContext context = (ClientContext)c;
        MasterMonitorInfo stats = null;
        int unassignedTablets = 1;
        for (int i = 0; unassignedTablets > 0 && i < 10; ++i) {
            Object client = null;
            while (true) {
                try {
                    client = MasterClient.getConnectionWithRetry((ClientContext)context);
                    stats = client.getMasterStats(TraceUtil.traceInfo(), context.rpcCreds());
                }
                catch (ThriftNotActiveServiceException e) {
                    log.debug("Contacted a Master which is no longer active, retrying");
                    Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                finally {
                    if (client == null) continue;
                    MasterClient.close((MasterClientService.Iface)client);
                    continue;
                }
                break;
            }
            unassignedTablets = stats.getUnassignedTablets();
            if (unassignedTablets <= 0) continue;
            log.info("Found {} unassigned tablets, sleeping 3 seconds for tablet assignment", (Object)unassignedTablets);
            Thread.sleep(3000L);
        }
        Assert.assertEquals((String)"Unassigned tablets were not assigned within 30 seconds", (long)0L, (long)unassignedTablets);
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (TabletServerStatus server : stats.tServerInfo) {
            int count = 0;
            for (TableInfo table : server.tableMap.values()) {
                count += table.onlineTablets;
            }
            counts.add(count);
        }
        Assert.assertTrue((String)"Expected to have at least two TabletServers", (counts.size() > 1 ? 1 : 0) != 0);
        for (int i = 1; i < counts.size(); ++i) {
            int diff = Math.abs((Integer)counts.get(0) - (Integer)counts.get(i));
            Assert.assertTrue((String)("Expected difference in tablets to be less than or equal to " + counts.size() + " but was " + diff + ". Counts " + counts), (diff <= counts.size() ? 1 : 0) != 0);
        }
    }
}

