/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.VolumeChooserIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;

public class VolumeIT
extends ConfigurableMacBase {
    private File volDirBase;
    private Path v1;
    private Path v2;
    private Path v3;
    private List<String> expected = new ArrayList<String>();

    @Override
    protected int defaultTimeoutSeconds() {
        return 600;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        File v3f = new File(this.volDirBase, "v3");
        this.v3 = new Path("file://" + v3f.getAbsolutePath());
        for (int i = 0; i < 100; ++i) {
            String row = String.format("%06d", i * 100 + 3);
            this.expected.add(row + ":cf1:cq1:1");
        }
        URI v1Uri = this.v1.toUri();
        cfg.setProperty(Property.INSTANCE_DFS_DIR, v1Uri.getPath());
        cfg.setProperty(Property.INSTANCE_DFS_URI, v1Uri.getScheme() + v1Uri.getHost());
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1 + "," + this.v2);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            TreeSet<Text> partitions = new TreeSet<Text>();
            for (String s : "d,m,t".split(",")) {
                partitions.add(new Text(s));
            }
            client.tableOperations().addSplits(tableName, partitions);
            VolumeChooserIT.writeDataToTable(client, tableName, VolumeChooserIT.alpha_rows);
            client.tableOperations().flush(tableName, null, null, true);
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                int i = 0;
                for (Map.Entry entry : scanner) {
                    Assert.assertEquals((Object)VolumeChooserIT.alpha_rows[i++], (Object)((Key)entry.getKey()).getRow().toString());
                }
            }
            scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            try {
                scanner.setRange(new Range((CharSequence)"1", (CharSequence)"1<"));
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                int fileCount = 0;
                for (Map.Entry entry : scanner) {
                    boolean inV1 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v1.toString());
                    boolean inV2 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v2.toString());
                    Assert.assertTrue((inV1 || inV2 ? 1 : 0) != 0);
                    ++fileCount;
                }
                Assert.assertEquals((long)4L, (long)fileCount);
                List diskUsage = client.tableOperations().getDiskUsage(Collections.singleton(tableName));
                Assert.assertEquals((long)1L, (long)diskUsage.size());
                long usage = ((DiskUsage)diskUsage.get(0)).getUsage();
                log.debug("usage {}", (Object)usage);
                Assert.assertTrue((usage > 700L && usage < 900L ? 1 : 0) != 0);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    private void verifyData(List<String> expected, Scanner createScanner) {
        ArrayList<String> actual = new ArrayList<String>();
        for (Map.Entry entry : createScanner) {
            Key k = (Key)entry.getKey();
            actual.add(k.getRow() + ":" + k.getColumnFamily() + ":" + k.getColumnQualifier() + ":" + entry.getValue());
        }
        Collections.sort(expected);
        Collections.sort(actual);
        createScanner.close();
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testRelativePaths() throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Mutation m;
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
            TreeSet<Text> partitions = new TreeSet<Text>();
            for (String s : "c,g,k,p,s,v".split(",")) {
                partitions.add(new Text(s));
            }
            client.tableOperations().addSplits(tableName, partitions);
            BatchWriter bw = client.createBatchWriter(tableName);
            for (String s : VolumeChooserIT.alpha_rows) {
                m = new Mutation((CharSequence)s);
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"1");
                bw.addMutation(m);
                expected.add(s + ":cf1:cq1:1");
            }
            bw.flush();
            client.tableOperations().flush(tableName, null, null, true);
            for (String s : VolumeChooserIT.alpha_rows) {
                m = new Mutation((CharSequence)s);
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"2");
                bw.addMutation(m);
                expected.add(s + ":cf1:cq1:2");
            }
            bw.close();
            client.tableOperations().flush(tableName, null, null, true);
            this.verifyData(expected, client.createScanner(tableName, Authorizations.EMPTY));
            client.tableOperations().offline(tableName, true);
            client.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
            try (Scanner metaScanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                metaScanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
                try (BatchWriter mbw = client.createBatchWriter(MetadataTable.NAME);){
                    for (Map.Entry entry : metaScanner) {
                        String cq = ((Key)entry.getKey()).getColumnQualifier().toString();
                        if (!cq.startsWith(this.v1.toString())) continue;
                        Path path = new Path(cq);
                        String relPath = "/" + path.getParent().getName() + "/" + path.getName();
                        Mutation fileMut = new Mutation(((Key)entry.getKey()).getRow());
                        fileMut.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
                        fileMut.put((CharSequence)((Key)entry.getKey()).getColumnFamily().toString(), (CharSequence)relPath, (CharSequence)((Value)entry.getValue()).toString());
                        mbw.addMutation(fileMut);
                    }
                }
                client.tableOperations().online(tableName, true);
                this.verifyData(expected, client.createScanner(tableName, Authorizations.EMPTY));
                client.tableOperations().compact(tableName, null, null, true, true);
                this.verifyData(expected, client.createScanner(tableName, Authorizations.EMPTY));
                for (Map.Entry entry : metaScanner) {
                    String cq = ((Key)entry.getKey()).getColumnQualifier().toString();
                    Path path = new Path(cq);
                    Assert.assertTrue((String)("relative path not deleted " + path), (path.depth() > 2 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testAddVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.getUniqueNames(2);
            String uuid = this.verifyAndShutdownCluster(client, tableNames[0]);
            FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(this.cluster.getAccumuloPropertiesPath())});
            ((PropertiesConfiguration)propsBuilder.getConfiguration()).setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(this.v1 + "," + this.v2 + "," + this.v3));
            propsBuilder.save();
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).getProcess().waitFor());
            this.checkVolumesInitialized(Arrays.asList(this.v1, this.v2, this.v3), uuid);
            this.cluster.start();
            this.verifyVolumesUsed(client, tableNames[1], false, this.v1, this.v2, this.v3);
        }
    }

    private String verifyAndShutdownCluster(AccumuloClient c, String tableName) throws Exception {
        String uuid = c.instanceOperations().getInstanceID();
        this.verifyVolumesUsed(c, tableName, false, this.v1, this.v2);
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        this.cluster.stop();
        return uuid;
    }

    @Test
    public void testNonConfiguredVolumes() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String uuid = this.verifyAndShutdownCluster(client, tableNames[0]);
            FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(this.cluster.getAccumuloPropertiesPath())});
            ((PropertiesConfiguration)propsBuilder.getConfiguration()).setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(this.v2 + "," + this.v3));
            propsBuilder.save();
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).getProcess().waitFor());
            this.checkVolumesInitialized(Arrays.asList(this.v1, this.v2, this.v3), uuid);
            this.cluster.start();
            this.verifyData(this.expected, client.createScanner(tableNames[0], Authorizations.EMPTY));
            this.verifyVolumesUsed(client, tableNames[1], false, this.v2, this.v3);
        }
    }

    private void checkVolumesInitialized(List<Path> volumes, String uuid) throws Exception {
        for (Path volumePath : volumes) {
            FileSystem fs = volumePath.getFileSystem(this.cluster.getServerContext().getHadoopConf());
            Path vp = new Path(volumePath, "instance_id");
            FileStatus[] iids = fs.listStatus(vp);
            Assert.assertEquals((long)1L, (long)iids.length);
            Assert.assertEquals((Object)uuid, (Object)iids[0].getPath().getName());
        }
    }

    private void writeData(String tableName, AccumuloClient client) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splits.add(new Text(String.format("%06d", i * 100)));
        }
        client.tableOperations().create(tableName);
        client.tableOperations().addSplits(tableName, splits);
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            for (int i = 0; i < 100; ++i) {
                String row = String.format("%06d", i * 100 + 3);
                Mutation m = new Mutation((CharSequence)row);
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"1");
                bw.addMutation(m);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyVolumesUsed(AccumuloClient client, String tableName, boolean shouldExist, Path ... paths) throws Exception {
        if (!client.tableOperations().exists(tableName)) {
            Assert.assertFalse((boolean)shouldExist);
            this.writeData(tableName, client);
            this.verifyData(this.expected, client.createScanner(tableName, Authorizations.EMPTY));
            client.tableOperations().flush(tableName, null, null, true);
        }
        this.verifyData(this.expected, client.createScanner(tableName, Authorizations.EMPTY));
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
        try (Scanner metaScanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)metaScanner);
            metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            metaScanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            int[] counts = new int[paths.length];
            block7: for (Object entry : metaScanner) {
                String string = ((Key)entry.getKey()).getColumnFamily().toString();
                String cq = ((Key)entry.getKey()).getColumnQualifier().toString();
                String path = string.equals(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME.toString()) ? cq : ((Value)entry.getValue()).toString();
                for (int i = 0; i < paths.length; ++i) {
                    if (!path.startsWith(paths[i].toString())) continue;
                    int n = i;
                    counts[n] = counts[n] + 1;
                    continue block7;
                }
                Assert.fail((String)("Unexpected volume " + path));
            }
            block9: while (true) {
                WalStateManager wals = new WalStateManager(this.getServerContext());
                try {
                    block10: for (Map.Entry entry : wals.getAllState().entrySet()) {
                        for (Path path : paths) {
                            if (((Path)entry.getKey()).toString().startsWith(path.toString())) continue block10;
                        }
                        log.warn("Unexpected volume " + entry.getKey() + " (" + entry.getValue() + ")");
                        continue block9;
                    }
                }
                catch (WalStateManager.WalMarkerException e) {
                    Throwable throwable = e.getCause();
                    if (!(throwable instanceof KeeperException.NoNodeException)) throw e;
                    continue;
                }
                break;
            }
            int sum = 0;
            for (int count : counts) {
                Assert.assertTrue((count > 0 ? 1 : 0) != 0);
                sum += count;
            }
            Assert.assertEquals((long)200L, (long)sum);
            return;
        }
    }

    @Test
    public void testRemoveVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.getUniqueNames(2);
            this.verifyVolumesUsed(client, tableNames[0], false, this.v1, this.v2);
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            this.cluster.stop();
            FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(this.cluster.getAccumuloPropertiesPath())});
            ((PropertiesConfiguration)propsBuilder.getConfiguration()).setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)this.v2.toString());
            propsBuilder.save();
            this.cluster.start();
            client.tableOperations().compact(tableNames[0], null, null, true, true);
            this.verifyVolumesUsed(client, tableNames[0], true, this.v2);
            ZooReader zreader = new ZooReader(this.cluster.getZooKeepers(), 30000);
            String zpath = ZooUtil.getRoot((String)client.instanceOperations().getInstanceID()) + "/root_tablet/dir";
            String rootTabletDir = new String(zreader.getData(zpath, false, null), StandardCharsets.UTF_8);
            Assert.assertTrue((boolean)rootTabletDir.startsWith(this.v2.toString()));
            client.tableOperations().clone(tableNames[0], tableNames[1], true, new HashMap(), new HashSet());
            client.tableOperations().flush(MetadataTable.NAME, null, null, true);
            client.tableOperations().flush(RootTable.NAME, null, null, true);
            this.verifyVolumesUsed(client, tableNames[0], true, this.v2);
            this.verifyVolumesUsed(client, tableNames[1], true, this.v2);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths provided by test")
    private void testReplaceVolume(AccumuloClient client, boolean cleanShutdown) throws Exception {
        String[] tableNames = this.getUniqueNames(3);
        this.verifyVolumesUsed(client, tableNames[0], false, this.v1, this.v2);
        this.writeData(tableNames[1], this.cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1")));
        if (cleanShutdown) {
            Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        }
        this.cluster.stop();
        File v1f = new File(this.v1.toUri());
        File v8f = new File(new File(this.v1.getParent().toUri()), "v8");
        Assert.assertTrue((String)("Failed to rename " + v1f + " to " + v8f), (boolean)v1f.renameTo(v8f));
        Path v8 = new Path(v8f.toURI());
        File v2f = new File(this.v2.toUri());
        File v9f = new File(new File(this.v2.getParent().toUri()), "v9");
        Assert.assertTrue((String)("Failed to rename " + v2f + " to " + v9f), (boolean)v2f.renameTo(v9f));
        Path v9 = new Path(v9f.toURI());
        FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName(this.cluster.getAccumuloPropertiesPath())});
        PropertiesConfiguration conf = (PropertiesConfiguration)propsBuilder.getConfiguration();
        conf.setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(v8 + "," + v9));
        conf.setProperty(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey(), (Object)(this.v1 + " " + v8 + "," + this.v2 + " " + v9));
        propsBuilder.save();
        this.cluster.start();
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        client.tableOperations().compact(tableNames[0], null, null, true, true);
        client.tableOperations().compact(tableNames[1], null, null, true, true);
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        ZooReader zreader = new ZooReader(this.cluster.getZooKeepers(), 30000);
        String zpath = ZooUtil.getRoot((String)client.instanceOperations().getInstanceID()) + "/root_tablet/dir";
        String rootTabletDir = new String(zreader.getData(zpath, false, null), StandardCharsets.UTF_8);
        Assert.assertTrue((rootTabletDir.startsWith(v8.toString()) || rootTabletDir.startsWith(v9.toString()) ? 1 : 0) != 0);
        client.tableOperations().clone(tableNames[1], tableNames[2], true, new HashMap(), new HashSet());
        client.tableOperations().flush(MetadataTable.NAME, null, null, true);
        client.tableOperations().flush(RootTable.NAME, null, null, true);
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[2], true, v8, v9);
    }

    @Test
    public void testCleanReplaceVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.testReplaceVolume(client, true);
        }
    }

    @Test
    public void testDirtyReplaceVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.testReplaceVolume(client, false);
        }
    }
}

