/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.fs.PerTableVolumeChooser;
import org.apache.accumulo.server.fs.PreferredVolumeChooser;
import org.apache.accumulo.server.fs.RandomVolumeChooser;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class VolumeChooserIT
extends ConfigurableMacBase {
    private static final String TP = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey();
    static final String PREFERRED_CHOOSER_PROP = TP + "volume.preferred";
    static final String PERTABLE_CHOOSER_PROP = TP + "volume.chooser";
    private static final String GP = Property.GENERAL_ARBITRARY_PROP_PREFIX.getKey();
    private static final Text EMPTY = new Text();
    private static final Value EMPTY_VALUE = new Value(new byte[0]);
    private File volDirBase;
    private Path v1;
    private Path v2;
    private Path v3;
    private Path v4;
    public static String[] alpha_rows = "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",");
    private String namespace1;
    private String namespace2;
    private String systemPreferredVolumes;

    static final String getPreferredProp(VolumeChooserEnvironment.ChooserScope scope) {
        return GP + "volume.preferred." + scope.name().toLowerCase();
    }

    static final String getPerTableProp(VolumeChooserEnvironment.ChooserScope scope) {
        return GP + "volume.chooser." + scope.name().toLowerCase();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
        this.namespace1 = "ns_" + this.getUniqueNames(2)[0];
        this.namespace2 = "ns_" + this.getUniqueNames(2)[1];
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.GENERAL_VOLUME_CHOOSER.getKey(), PerTableVolumeChooser.class.getName());
        siteConfig.put(PERTABLE_CHOOSER_PROP, PreferredVolumeChooser.class.getName());
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        File v3f = new File(this.volDirBase, "v3");
        File v4f = new File(this.volDirBase, "v4");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        this.v3 = new Path("file://" + v3f.getAbsolutePath());
        this.v4 = new Path("file://" + v4f.getAbsolutePath());
        this.systemPreferredVolumes = this.v1 + "," + this.v2;
        siteConfig.put(PREFERRED_CHOOSER_PROP, this.systemPreferredVolumes);
        cfg.setSiteConfig(siteConfig);
        siteConfig.put(VolumeChooserIT.getPerTableProp(VolumeChooserEnvironment.ChooserScope.LOGGER), PreferredVolumeChooser.class.getName());
        siteConfig.put(VolumeChooserIT.getPreferredProp(VolumeChooserEnvironment.ChooserScope.LOGGER), this.v2.toString());
        cfg.setSiteConfig(siteConfig);
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1 + "," + this.v2 + "," + this.v4);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    public static void addSplits(AccumuloClient accumuloClient, String tableName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        TreeSet<Text> partitions = new TreeSet<Text>();
        for (String s : alpha_rows) {
            partitions.add(new Text(s));
        }
        accumuloClient.tableOperations().addSplits(tableName, partitions);
    }

    public static void writeAndReadData(AccumuloClient accumuloClient, String tableName) throws Exception {
        VolumeChooserIT.writeDataToTable(accumuloClient, tableName, alpha_rows);
        accumuloClient.tableOperations().flush(tableName, null, null, true);
        try (Scanner scanner = accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            int i = 0;
            for (Map.Entry entry : scanner) {
                Assert.assertEquals((String)"Data read is not data written", (Object)alpha_rows[i++], (Object)((Key)entry.getKey()).getRow().toString());
            }
        }
    }

    public static void writeDataToTable(AccumuloClient accumuloClient, String tableName, String[] rows) throws Exception {
        try (BatchWriter bw = accumuloClient.createBatchWriter(tableName);){
            for (String s : rows) {
                Mutation m = new Mutation(new Text(s));
                m.put(EMPTY, EMPTY, EMPTY_VALUE);
                bw.addMutation(m);
            }
        }
    }

    public static void verifyVolumes(AccumuloClient accumuloClient, Range tableRange, String vol) throws Exception {
        ArrayList<String> volumes = new ArrayList<String>();
        for (String s : vol.split(",")) {
            volumes.add(s);
        }
        TreeSet<String> volumesSeen = new TreeSet<String>();
        int fileCount = 0;
        try (Scanner scanner = accumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(tableRange);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                boolean inVolume = false;
                for (String volume : volumes) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains(volume)) continue;
                    volumesSeen.add(volume);
                    inVolume = true;
                }
                Assert.assertTrue((String)("Data not written to the correct volumes.  " + ((Key)entry.getKey()).getColumnQualifier()), (boolean)inVolume);
                ++fileCount;
            }
        }
        Assert.assertEquals((String)("Did not see all the volumes. volumes: " + volumes + " volumes seen: " + volumesSeen), (long)volumes.size(), (long)volumesSeen.size());
        Assert.assertEquals((String)"Wrong number of files", (long)26L, (long)fileCount);
    }

    public static void verifyNoVolumes(AccumuloClient accumuloClient, Range tableRange) throws Exception {
        try (Scanner scanner = accumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(tableRange);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                Assert.fail((String)("Data incorrectly written to " + ((Key)entry.getKey()).getColumnQualifier()));
            }
        }
    }

    private void configureNamespace(AccumuloClient accumuloClient, String volumeChooserClassName, String configuredVolumes, String namespace) throws Exception {
        accumuloClient.namespaceOperations().create(namespace);
        accumuloClient.namespaceOperations().setProperty(namespace, PERTABLE_CHOOSER_PROP, volumeChooserClassName);
        accumuloClient.namespaceOperations().setProperty(namespace, PREFERRED_CHOOSER_PROP, configuredVolumes);
    }

    private void verifyVolumesForWritesToNewTable(AccumuloClient accumuloClient, String myNamespace, String expectedVolumes) throws Exception {
        String tableName = myNamespace + ".1";
        accumuloClient.tableOperations().create(tableName);
        TableId tableID = TableId.of((String)((String)accumuloClient.tableOperations().tableIdMap().get(tableName)));
        VolumeChooserIT.addSplits(accumuloClient, tableName);
        VolumeChooserIT.writeAndReadData(accumuloClient, tableName);
        VolumeChooserIT.verifyVolumes(accumuloClient, MetadataSchema.TabletsSection.getRange((TableId)tableID), expectedVolumes);
    }

    public static void verifyWaLogVolumes(AccumuloClient accumuloClient, Range tableRange, String vol) throws TableNotFoundException {
        ArrayList<String> volumes = new ArrayList<String>();
        for (String s : vol.split(",")) {
            volumes.add(s);
        }
        TreeSet<String> volumesSeen = new TreeSet<String>();
        try (Scanner scanner = accumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(tableRange);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                boolean inVolume = false;
                for (String volume : volumes) {
                    if (((Key)entry.getKey()).getColumnQualifier().toString().contains(volume)) {
                        volumesSeen.add(volume);
                    }
                    inVolume = true;
                }
                Assert.assertTrue((String)("Data not written to the correct volumes.  " + ((Key)entry.getKey()).getColumnQualifier()), (boolean)inVolume);
            }
        }
    }

    @Test
    public void twoTablesPreferredVolumeChooser() throws Exception {
        log.info("Starting twoTablesPreferredVolumeChooser");
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.configureNamespace(c, PreferredVolumeChooser.class.getName(), this.v2.toString(), this.namespace1);
            this.verifyVolumesForWritesToNewTable(c, this.namespace1, this.v2.toString());
            this.configureNamespace(c, PreferredVolumeChooser.class.getName(), this.v1.toString(), this.namespace2);
            this.verifyVolumesForWritesToNewTable(c, this.namespace2, this.v1.toString());
        }
    }

    @Test
    public void twoTablesRandomVolumeChooser() throws Exception {
        log.info("Starting twoTablesRandomVolumeChooser()");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.createAndVerify(client, this.namespace1, this.v1 + "," + this.v2 + "," + this.v4);
            this.createAndVerify(client, this.namespace2, this.v1 + "," + this.v2 + "," + this.v4);
        }
    }

    private void createAndVerify(AccumuloClient client, String ns, String expectedVolumes) throws Exception {
        client.namespaceOperations().create(ns);
        client.namespaceOperations().setProperty(ns, PERTABLE_CHOOSER_PROP, RandomVolumeChooser.class.getName());
        this.verifyVolumesForWritesToNewTable(client, ns, expectedVolumes);
    }

    @Test
    public void twoTablesDiffChoosers() throws Exception {
        log.info("Starting twoTablesDiffChoosers");
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.createAndVerify(c, this.namespace1, this.v1 + "," + this.v2 + "," + this.v4);
            this.configureNamespace(c, PreferredVolumeChooser.class.getName(), this.v1.toString(), this.namespace2);
            this.verifyVolumesForWritesToNewTable(c, this.namespace2, this.v1.toString());
        }
    }

    @Test
    public void includeSpecialVolumeForTable() throws Exception {
        log.info("Starting includeSpecialVolumeForTable");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String configuredVolumes = this.v4.toString();
            this.configureNamespace(client, PreferredVolumeChooser.class.getName(), configuredVolumes, this.namespace2);
            this.verifyVolumesForWritesToNewTable(client, this.namespace2, configuredVolumes);
        }
    }

    @Test
    public void waLogsSentToConfiguredVolumes() throws Exception {
        log.info("Starting waLogsSentToConfiguredVolumes");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = "anotherTable";
            client.tableOperations().create(tableName);
            VolumeChooserIT.addSplits(client, tableName);
            VolumeChooserIT.writeDataToTable(client, tableName, alpha_rows);
            VolumeChooserIT.verifyWaLogVolumes(client, new Range(), this.v2.toString());
        }
    }
}

