/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class TestIngest {
    public static final Authorizations AUTHS = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});
    private static byte[] ROW_PREFIX = "row_".getBytes(StandardCharsets.UTF_8);
    private static byte[] COL_PREFIX = "col_".getBytes(StandardCharsets.UTF_8);

    public static void createTable(AccumuloClient client, IngestParams params) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        if (params.createTable) {
            TreeSet<Text> splits = TestIngest.getSplitPoints(params.startRow, params.startRow + params.rows, params.numsplits);
            if (!client.tableOperations().exists(params.tableName)) {
                client.tableOperations().create(params.tableName);
            }
            try {
                client.tableOperations().addSplits(params.tableName, splits);
            }
            catch (TableNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static TreeSet<Text> getSplitPoints(long start, long end, long numsplits) {
        long splitSize = (end - start) / numsplits;
        TreeSet<Text> splits = new TreeSet<Text>();
        for (long pos = start + splitSize; pos < end; pos += splitSize) {
            splits.add(new Text(String.format("row_%010d", pos)));
        }
        return splits;
    }

    public static byte[][] generateValues(int dataSize) {
        byte[][] bytevals = new byte[10][];
        byte[] letters = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
        for (int i = 0; i < 10; ++i) {
            bytevals[i] = new byte[dataSize];
            for (int j = 0; j < dataSize; ++j) {
                bytevals[i][j] = letters[i];
            }
        }
        return bytevals;
    }

    public static Text generateRow(int rowid, int startRow) {
        return new Text(FastFormat.toZeroPaddedString((long)(rowid + startRow), (int)10, (int)10, (byte[])ROW_PREFIX));
    }

    public static byte[] genRandomValue(Random random, byte[] dest, int seed, int row, int col) {
        random.setSeed(row ^ seed ^ col);
        random.nextBytes(dest);
        TestIngest.toPrintableChars(dest);
        return dest;
    }

    public static void toPrintableChars(byte[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = (byte)((0xFF & dest[i]) % 92 + 32);
        }
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(TestIngest.class.getSimpleName(), args, new Object[0]);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
            TestIngest.ingest(client, opts.getIngestPrams());
        }
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="predictable random is okay for testing")
    public static void ingest(AccumuloClient accumuloClient, FileSystem fs, IngestParams params) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, TableExistsException {
        byte[][] bytevals = TestIngest.generateValues(params.dataSize);
        byte[] randomValue = new byte[params.dataSize];
        Random random = new Random();
        long bytesWritten = 0L;
        TestIngest.createTable(accumuloClient, params);
        BatchWriter bw = null;
        FileSKVWriter writer = null;
        if (params.outputFile != null) {
            ClientContext cc = (ClientContext)accumuloClient;
            writer = FileOperations.getInstance().newWriterBuilder().forFile(params.outputFile + "." + "rf", fs, cc.getHadoopConf(), CryptoServiceFactory.newDefaultInstance()).withTableConfiguration((AccumuloConfiguration)DefaultConfiguration.getInstance()).build();
            writer.startDefaultLocalityGroup();
        } else {
            bw = accumuloClient.createBatchWriter(params.tableName);
            String principal = ClientProperty.AUTH_PRINCIPAL.getValue(params.clientProps);
            accumuloClient.securityOperations().changeUserAuthorizations(principal, AUTHS);
        }
        Text labBA = new Text(params.columnVisibility.getExpression());
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < params.rows; ++i) {
            int rowid = params.stride > 0 ? i % params.stride * (params.rows / params.stride) + i / params.stride : i;
            Text row = TestIngest.generateRow(rowid, params.startRow);
            Mutation m = new Mutation(row);
            for (int j = 0; j < params.cols; ++j) {
                byte[] value;
                Key key;
                Text colf = new Text(params.columnFamily);
                Text colq = new Text(FastFormat.toZeroPaddedString((long)j, (int)7, (int)10, (byte[])COL_PREFIX));
                if (writer != null) {
                    key = new Key(row, colf, colq, labBA);
                    if (params.timestamp >= 0L) {
                        key.setTimestamp(params.timestamp);
                    } else {
                        key.setTimestamp(startTime);
                    }
                    if (params.delete) {
                        key.setDeleted(true);
                    } else {
                        key.setDeleted(false);
                    }
                    bytesWritten += (long)key.getSize();
                    if (params.delete) {
                        writer.append(key, new Value(new byte[0]));
                        continue;
                    }
                    value = params.random != null ? TestIngest.genRandomValue(random, randomValue, params.random, rowid + params.startRow, j) : bytevals[j % bytevals.length];
                    Value v = new Value(value);
                    writer.append(key, v);
                    bytesWritten += (long)v.getSize();
                    continue;
                }
                key = new Key(row, colf, colq, labBA);
                bytesWritten += (long)key.getSize();
                if (params.delete) {
                    if (params.timestamp >= 0L) {
                        m.putDelete(colf, colq, params.columnVisibility, params.timestamp);
                        continue;
                    }
                    m.putDelete(colf, colq, params.columnVisibility);
                    continue;
                }
                value = params.random != null ? TestIngest.genRandomValue(random, randomValue, params.random, rowid + params.startRow, j) : bytevals[j % bytevals.length];
                bytesWritten += (long)value.length;
                if (params.timestamp >= 0L) {
                    m.put(colf, colq, params.columnVisibility, params.timestamp, new Value(value, true));
                    continue;
                }
                m.put(colf, colq, params.columnVisibility, new Value(value, true));
            }
            if (bw == null) continue;
            bw.addMutation(m);
        }
        if (writer != null) {
            writer.close();
        } else if (bw != null) {
            try {
                bw.close();
            }
            catch (MutationsRejectedException e) {
                if (e.getSecurityErrorCodes().size() > 0) {
                    for (Map.Entry entry : e.getSecurityErrorCodes().entrySet()) {
                        System.err.println("ERROR : Not authorized to write to : " + entry.getKey() + " due to " + entry.getValue());
                    }
                }
                if (e.getConstraintViolationSummaries().size() > 0) {
                    for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                        System.err.println("ERROR : Constraint violates : " + cvs);
                    }
                }
                throw e;
            }
        }
        long stopTime = System.currentTimeMillis();
        int totalValues = params.rows * params.cols;
        double elapsed = (double)(stopTime - startTime) / 1000.0;
        System.out.printf("%,12d records written | %,8d records/sec | %,12d bytes written | %,8d bytes/sec | %6.3f secs   %n", totalValues, (int)((double)totalValues / elapsed), bytesWritten, (int)((double)bytesWritten / elapsed), elapsed);
    }

    public static void ingest(AccumuloClient c, IngestParams params) throws MutationsRejectedException, IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        ClientContext cc = (ClientContext)c;
        TestIngest.ingest(c, FileSystem.get((Configuration)cc.getHadoopConf()), params);
    }

    public static class Opts
    extends ClientOpts {
        @Parameter(names={"--table"}, description="table to use")
        String tableName = "test_ingest";
        @Parameter(names={"--createTable"})
        boolean createTable = false;
        @Parameter(names={"--splits"}, description="the number of splits to use when creating the table")
        int numsplits = 1;
        @Parameter(names={"--start"}, description="the starting row number")
        int startRow = 0;
        @Parameter(names={"--rows"}, description="the number of rows to ingest")
        int rows = 100000;
        @Parameter(names={"--cols"}, description="the number of columns to ingest per row")
        int cols = 1;
        @Parameter(names={"--random"}, description="insert random rows and use the given number to seed the psuedo-random number generator")
        Integer random = null;
        @Parameter(names={"--size"}, description="the size of the value to ingest")
        int dataSize = 1000;
        @Parameter(names={"--delete"}, description="delete values instead of inserting them")
        boolean delete = false;
        @Parameter(names={"-ts", "--timestamp"}, description="timestamp to use for all values")
        long timestamp = -1L;
        @Parameter(names={"--rfile"}, description="generate data into a file that can be imported")
        String outputFile = null;
        @Parameter(names={"--stride"}, description="the difference between successive row ids")
        int stride;
        @Parameter(names={"-cf", "--columnFamily"}, description="place columns in this column family")
        String columnFamily = "colf";
        @Parameter(names={"-cv", "--columnVisibility"}, description="place columns in this column family", converter=ClientOpts.VisibilityConverter.class)
        ColumnVisibility columnVisibility = new ColumnVisibility();

        protected void populateIngestPrams(IngestParams params) {
            params.createTable = this.createTable;
            params.numsplits = this.numsplits;
            params.startRow = this.startRow;
            params.rows = this.rows;
            params.cols = this.cols;
            params.random = this.random;
            params.dataSize = this.dataSize;
            params.delete = this.delete;
            params.timestamp = this.timestamp;
            params.outputFile = this.outputFile;
            params.stride = this.stride;
            params.columnFamily = this.columnFamily;
            params.columnVisibility = this.columnVisibility;
        }

        public IngestParams getIngestPrams() {
            IngestParams params = new IngestParams(this.getClientProps(), this.tableName);
            this.populateIngestPrams(params);
            return params;
        }
    }

    public static class IngestParams {
        public Properties clientProps = new Properties();
        public String tableName = "test_ingest";
        public boolean createTable = false;
        public int numsplits = 1;
        public int startRow = 0;
        public int rows = 100000;
        public int cols = 1;
        public Integer random = null;
        public int dataSize = 1000;
        public boolean delete = false;
        public long timestamp = -1L;
        public String outputFile = null;
        public int stride;
        public String columnFamily = "colf";
        public ColumnVisibility columnVisibility = new ColumnVisibility();

        public IngestParams(Properties props) {
            this.clientProps = props;
        }

        public IngestParams(Properties props, String table) {
            this(props);
            this.tableName = table;
        }

        public IngestParams(Properties props, String table, int rows) {
            this(props, table);
            this.rows = rows;
        }
    }
}

