/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Map;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class TestCompactionStrategy
extends CompactionStrategy {
    private String inputPrefix = "Z";
    private String dropPrefix = "Z";
    private boolean shouldCompact = false;

    public void init(Map<String, String> options) {
        if (options.containsKey("inputPrefix")) {
            this.inputPrefix = options.get("inputPrefix");
        }
        if (options.containsKey("dropPrefix")) {
            this.dropPrefix = options.get("dropPrefix");
        }
        if (options.containsKey("shouldCompact")) {
            this.shouldCompact = Boolean.parseBoolean(options.get("shouldCompact"));
        }
    }

    public boolean shouldCompact(MajorCompactionRequest request) {
        if (this.shouldCompact) {
            return true;
        }
        for (FileRef fref : request.getFiles().keySet()) {
            if (fref.path().getName().startsWith(this.inputPrefix)) {
                return true;
            }
            if (!fref.path().getName().startsWith(this.dropPrefix)) continue;
            return true;
        }
        return false;
    }

    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        CompactionPlan plan = new CompactionPlan();
        for (FileRef fref : request.getFiles().keySet()) {
            if (fref.path().getName().startsWith(this.dropPrefix)) {
                plan.deleteFiles.add(fref);
                continue;
            }
            if (!fref.path().getName().startsWith(this.inputPrefix)) continue;
            plan.inputFiles.add(fref);
        }
        return plan;
    }
}

