/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.hadoop.io.Text;

public class TestBinaryRows {
    private static final long byteOnes;

    static byte[] encodeLong(long l) {
        byte[] ba = new byte[8];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)(byteOnes & l >>> 8 * (ba.length - i - 1));
        }
        return ba;
    }

    static long decodeLong(byte[] ba) {
        if (ba.length > 8) {
            throw new IllegalArgumentException("Byte array of size " + ba.length + " is too big to hold a long");
        }
        long l = 0L;
        for (int i = 0; i < ba.length; ++i) {
            l |= (byteOnes & (long)ba[i]) << 8 * (ba.length - i - 1);
        }
        return l;
    }

    public static void runTest(AccumuloClient accumuloClient, Opts opts) throws Exception {
        block40: {
            Text CF = new Text("cf");
            Text CQ = new Text("cq");
            byte[] CF_BYTES = "cf".getBytes(StandardCharsets.UTF_8);
            byte[] CQ_BYTES = "cq".getBytes(StandardCharsets.UTF_8);
            if (opts.mode.equals("ingest") || opts.mode.equals("delete")) {
                try (BatchWriter bw = accumuloClient.createBatchWriter(opts.tableName);){
                    boolean delete = opts.mode.equals("delete");
                    for (long i = 0L; i < opts.num; ++i) {
                        byte[] row = TestBinaryRows.encodeLong(i + opts.start);
                        String value = "" + (i + opts.start);
                        Mutation m = new Mutation(new Text(row));
                        if (delete) {
                            m.putDelete(CF, CQ);
                        } else {
                            m.put(CF, CQ, new Value(value.getBytes(StandardCharsets.UTF_8)));
                        }
                        bw.addMutation(m);
                    }
                }
            }
            if (opts.mode.equals("verifyDeleted")) {
                try (Scanner s = accumuloClient.createScanner(opts.tableName, opts.auths);){
                    Key startKey = new Key(TestBinaryRows.encodeLong(opts.start), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                    Key stopKey = new Key(TestBinaryRows.encodeLong(opts.start + opts.num - 1L), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                    s.setBatchSize(50000);
                    s.setRange(new Range(startKey, stopKey));
                    Iterator iterator = s.iterator();
                    if (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        throw new Exception("ERROR : saw entries in range that should be deleted ( first value : " + entry.getValue() + ")");
                    }
                    break block40;
                }
            }
            if (opts.mode.equals("verify")) {
                long t1 = System.currentTimeMillis();
                try (Scanner s = accumuloClient.createScanner(opts.tableName, opts.auths);){
                    Key startKey = new Key(TestBinaryRows.encodeLong(opts.start), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                    Key stopKey = new Key(TestBinaryRows.encodeLong(opts.start + opts.num - 1L), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                    s.setRange(new Range(startKey, stopKey));
                    long i = opts.start;
                    for (Map.Entry e : s) {
                        Key k = (Key)e.getKey();
                        Value v = (Value)e.getValue();
                        TestBinaryRows.checkKeyValue(i, k, v);
                        ++i;
                    }
                    if (i != opts.start + opts.num) {
                        throw new Exception("ERROR : did not see expected number of rows, saw " + (i - opts.start) + " expected " + opts.num);
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.printf("time : %9.2f secs%n", (double)(t2 - t1) / 1000.0);
                    System.out.printf("rate : %9.2f entries/sec%n", (double)opts.num / ((double)(t2 - t1) / 1000.0));
                }
            }
            if (opts.mode.equals("randomLookups")) {
                int numLookups = 1000;
                SecureRandom r = new SecureRandom();
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < numLookups; ++i) {
                    long row = (r.nextLong() & Long.MAX_VALUE) % opts.num + opts.start;
                    try (Scanner s = accumuloClient.createScanner(opts.tableName, opts.auths);){
                        Key startKey = new Key(TestBinaryRows.encodeLong(row), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                        Key stopKey = new Key(TestBinaryRows.encodeLong(row), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                        s.setRange(new Range(startKey, stopKey));
                        Iterator si = s.iterator();
                        if (si.hasNext()) {
                            Map.Entry e = (Map.Entry)si.next();
                            Key k = (Key)e.getKey();
                            Value v = (Value)e.getValue();
                            TestBinaryRows.checkKeyValue(row, k, v);
                            if (!si.hasNext()) continue;
                            throw new Exception("ERROR : lookup on " + row + " returned more than one result ");
                        }
                        throw new Exception("ERROR : lookup on " + row + " failed ");
                    }
                }
                long t2 = System.currentTimeMillis();
                System.out.printf("time    : %9.2f secs%n", (double)(t2 - t1) / 1000.0);
                System.out.printf("lookups : %9d keys%n", numLookups);
                System.out.printf("rate    : %9.2f lookups/sec%n", (double)numLookups / ((double)(t2 - t1) / 1000.0));
            } else if (opts.mode.equals("split")) {
                TreeSet<Text> splits = new TreeSet<Text>();
                int shift = (int)opts.start;
                int count = (int)opts.num;
                for (long i = 0L; i < (long)count; ++i) {
                    long splitPoint = i << shift;
                    splits.add(new Text(TestBinaryRows.encodeLong(splitPoint)));
                    System.out.printf("added split point 0x%016x  %,12d%n", splitPoint, splitPoint);
                }
                accumuloClient.tableOperations().create(opts.tableName);
                accumuloClient.tableOperations().addSplits(opts.tableName, splits);
            } else {
                throw new Exception("ERROR : " + opts.mode + " is not a valid operation.");
            }
        }
    }

    private static void checkKeyValue(long expected, Key k, Value v) throws Exception {
        if (expected != TestBinaryRows.decodeLong(TextUtil.getBytes((Text)k.getRow()))) {
            throw new Exception("ERROR : expected row " + expected + " saw " + TestBinaryRows.decodeLong(TextUtil.getBytes((Text)k.getRow())));
        }
        if (!v.toString().equals("" + expected)) {
            throw new Exception("ERROR : expected value " + expected + " saw " + v);
        }
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(TestBinaryRows.class.getName(), args, new Object[0]);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
            TestBinaryRows.runTest(client, opts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        long b = 1L;
        for (int i = 0; i < 8; ++i) {
            b |= 1L << i;
        }
        byteOnes = b;
    }

    public static class Opts
    extends ServerUtilOpts {
        @Parameter(names={"--mode"}, description="either 'ingest', 'delete', 'randomLookups', 'split', 'verify', 'verifyDeleted'", required=true)
        public String mode;
        @Parameter(names={"--start"}, description="the lowest numbered row")
        public long start = 0L;
        @Parameter(names={"--count"}, description="number of rows to ingest", required=true)
        public long num = 0L;
        @Parameter(names={"-t", "--table"}, required=true, description="table to use")
        public String tableName;
    }
}

