/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TabletServerGivesUpIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "10s");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_CREATION_FAILURES, "10");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_WAIT_INCREMENT, "0s");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_MAXIMUM_WAIT_DURATION, "0s");
    }

    @Test(timeout=45000L)
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            while (client.instanceOperations().getTabletServers().isEmpty()) {
                Thread.sleep(100L);
            }
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            this.cluster.getMiniDfs().shutdown();
            AtomicReference ex = new AtomicReference();
            Thread splitter = new Thread(() -> {
                try {
                    TreeSet<Text> splits = new TreeSet<Text>();
                    splits.add(new Text("X"));
                    client.tableOperations().addSplits(tableName, splits);
                }
                catch (Exception e) {
                    ex.set(e);
                }
            });
            splitter.start();
            while (client.instanceOperations().getTabletServers().size() == 1) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }
}

