/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.DefaultKeySizeConstraint;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.HardListIterator;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableOperationsIT
extends AccumuloClusterHarness {
    static TabletClientService.Client client;
    private AccumuloClient accumuloClient;
    static final KeyRowColFColQComparator COMPARE_KEY_TO_COLQ;

    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Before
    public void setup() {
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(TableOperationsIT.getClientProps()).build();
    }

    @After
    public void checkForDanglingFateLocks() {
        FunctionalTestUtils.assertNoDanglingFateLocks((ClientContext)this.accumuloClient, TableOperationsIT.getCluster());
        this.accumuloClient.close();
    }

    @Test
    public void getDiskUsageErrors() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        List diskUsage = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assert.assertEquals((long)1L, (long)diskUsage.size());
        Assert.assertEquals((long)0L, (long)((DiskUsage)diskUsage.get(0)).getUsage());
        Assert.assertEquals((Object)tableName, ((DiskUsage)diskUsage.get(0)).getTables().iterator().next());
        this.accumuloClient.securityOperations().revokeTablePermission(TableOperationsIT.getAdminPrincipal(), tableName, TablePermission.READ);
        try {
            this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
            Assert.fail((String)"Should throw securityexception");
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        this.accumuloClient.tableOperations().delete(tableName);
        try {
            this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
            Assert.fail((String)"Should throw tablenotfound");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void getDiskUsage() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String[] names = this.getUniqueNames(2);
        String tableName = names[0];
        this.accumuloClient.tableOperations().create(tableName);
        List diskUsages = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assert.assertEquals((long)1L, (long)diskUsages.size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assert.assertEquals((Object)0L, (Object)((DiskUsage)diskUsages.get(0)).getUsage());
        Assert.assertEquals((Object)tableName, ((DiskUsage)diskUsages.get(0)).getTables().first());
        try (BatchWriter bw = this.accumuloClient.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"a");
            m.put((CharSequence)"b", (CharSequence)"c", new Value("abcde".getBytes()));
            bw.addMutation(m);
            bw.flush();
        }
        this.accumuloClient.tableOperations().compact(tableName, new Text("A"), new Text("z"), true, true);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(Collections.singleton(tableName));
        Assert.assertEquals((long)1L, (long)diskUsages.size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assert.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)tableName, ((DiskUsage)diskUsages.get(0)).getTables().first());
        String newTable = names[1];
        this.accumuloClient.tableOperations().clone(tableName, newTable, false, null, null);
        HashSet<String> tables = new HashSet<String>();
        tables.add(tableName);
        tables.add(newTable);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(tables);
        Assert.assertEquals((long)1L, (long)diskUsages.size());
        Assert.assertEquals((long)2L, (long)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assert.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        this.accumuloClient.tableOperations().compact(tableName, new Text("A"), new Text("z"), true, true);
        this.accumuloClient.tableOperations().compact(newTable, new Text("A"), new Text("z"), true, true);
        diskUsages = this.accumuloClient.tableOperations().getDiskUsage(tables);
        Assert.assertEquals((long)2L, (long)diskUsages.size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsages.get(0)).getTables().size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsages.get(1)).getTables().size());
        Assert.assertTrue((((DiskUsage)diskUsages.get(0)).getUsage() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((((DiskUsage)diskUsages.get(1)).getUsage() > 0L ? 1 : 0) != 0);
        this.accumuloClient.tableOperations().delete(tableName);
    }

    @Test
    public void createTable() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        Iterable itrProps = this.accumuloClient.tableOperations().getProperties(tableName);
        Map<String, String> props = this.propsToMap(itrProps);
        Assert.assertEquals((Object)DefaultKeySizeConstraint.class.getName(), (Object)props.get(Property.TABLE_CONSTRAINT_PREFIX + "1"));
        this.accumuloClient.tableOperations().delete(tableName);
    }

    @Test
    public void createMergeClonedTable() throws Exception {
        String[] names = this.getUniqueNames(2);
        String originalTable = names[0];
        TableOperations tops = this.accumuloClient.tableOperations();
        TreeSet splits = Sets.newTreeSet(Arrays.asList(new Text("a"), new Text("b"), new Text("c"), new Text("d")));
        tops.create(originalTable);
        tops.addSplits(originalTable, (SortedSet)splits);
        try (BatchWriter bw = this.accumuloClient.createBatchWriter(originalTable);){
            for (Text row : splits) {
                Mutation m = new Mutation(row);
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        m.put((CharSequence)Integer.toString(i), (CharSequence)Integer.toString(j), (CharSequence)Integer.toString(i + j));
                    }
                }
                bw.addMutation(m);
            }
        }
        String clonedTable = names[1];
        tops.clone(originalTable, clonedTable, true, null, null);
        tops.merge(clonedTable, null, new Text("b"));
        HashMap<String, Integer> rowCounts = new HashMap<String, Integer>();
        try (Scanner s = this.accumuloClient.createScanner(clonedTable, new Authorizations());){
            for (Map.Entry entry : s) {
                Key key = (Key)entry.getKey();
                String row = key.getRow().toString();
                String cf = key.getColumnFamily().toString();
                String cq = key.getColumnQualifier().toString();
                String value = ((Value)entry.getValue()).toString();
                if (rowCounts.containsKey(row)) {
                    rowCounts.put(row, (Integer)rowCounts.get(row) + 1);
                } else {
                    rowCounts.put(row, 1);
                }
                Assert.assertEquals((long)(Integer.parseInt(cf) + Integer.parseInt(cq)), (long)Integer.parseInt(value));
            }
        }
        Collection clonedSplits = tops.listSplits(clonedTable);
        HashSet expectedSplits = Sets.newHashSet((Object[])new Text[]{new Text("b"), new Text("c"), new Text("d")});
        for (Text clonedSplit : clonedSplits) {
            Assert.assertTrue((String)("Encountered unexpected split on the cloned table: " + clonedSplit), (boolean)expectedSplits.remove(clonedSplit));
        }
        Assert.assertTrue((String)("Did not find all expected splits on the cloned table: " + expectedSplits), (boolean)expectedSplits.isEmpty());
    }

    private Map<String, String> propsToMap(Iterable<Map.Entry<String, String>> props) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> prop : props) {
            map.put(prop.getKey(), prop.getValue());
        }
        return map;
    }

    @Test
    public void testCompactEmptyTableWithGeneratorIterator() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, HardListIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, null, null, list, true, true);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>(COMPARE_KEY_TO_COLQ);
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assert.assertEquals(HardListIterator.allEntriesToInject, actual);
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    @Test
    public void testCompactEmptyTableWithGeneratorIterator_Splits() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        TreeSet<Text> splitset = new TreeSet<Text>();
        splitset.add(new Text("f"));
        this.accumuloClient.tableOperations().addSplits(tableName, splitset);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, HardListIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, null, null, list, true, true);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>(COMPARE_KEY_TO_COLQ);
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assert.assertEquals(HardListIterator.allEntriesToInject, actual);
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    @Test
    public void testCompactEmptyTableWithGeneratorIterator_Splits_Cancel() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        TreeSet<Text> splitset = new TreeSet<Text>();
        splitset.add(new Text("f"));
        this.accumuloClient.tableOperations().addSplits(tableName, splitset);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, HardListIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, null, null, list, true, false);
        this.accumuloClient.tableOperations().cancelCompaction(tableName);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>(COMPARE_KEY_TO_COLQ);
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            switch (actual.size()) {
                case 3: {
                    Assert.assertEquals(HardListIterator.allEntriesToInject, actual);
                    break;
                }
                case 2: {
                    Assert.assertEquals(HardListIterator.allEntriesToInject.headMap(new Key((CharSequence)"f")), actual);
                    break;
                }
                case 1: {
                    Assert.assertEquals(HardListIterator.allEntriesToInject.tailMap(new Key((CharSequence)"f")), actual);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    Assert.fail((String)"Unexpected number of entries");
                }
            }
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    @Test
    public void testCompactEmptyTableWithGeneratorIterator_Splits_Partial() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        Text splitRow = new Text("f");
        TreeSet<Text> splitset = new TreeSet<Text>();
        splitset.add(splitRow);
        this.accumuloClient.tableOperations().addSplits(tableName, splitset);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, HardListIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, splitRow, null, list, true, true);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>(COMPARE_KEY_TO_COLQ);
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assert.assertEquals(HardListIterator.allEntriesToInject.tailMap(new Key(splitRow)), actual);
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    @Test
    public void testCompactEmptyTablesWithBadIterator_FailsAndCancel() throws TableExistsException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = this.getUniqueNames(1)[0];
        this.accumuloClient.tableOperations().create(tableName);
        ArrayList<IteratorSetting> list = new ArrayList<IteratorSetting>();
        list.add(new IteratorSetting(15, BadIterator.class));
        this.accumuloClient.tableOperations().compact(tableName, null, null, list, true, false);
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        this.accumuloClient.tableOperations().cancelCompaction(tableName);
        try (Scanner scanner = this.accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            TreeMap<Key, Value> actual = new TreeMap<Key, Value>();
            for (Map.Entry entry : scanner) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assert.assertTrue((String)("Should be empty. Actual is " + actual), (boolean)actual.isEmpty());
            this.accumuloClient.tableOperations().delete(tableName);
        }
    }

    static {
        COMPARE_KEY_TO_COLQ = new KeyRowColFColQComparator();
    }

    static class KeyRowColFColQComparator
    implements Comparator<Key> {
        KeyRowColFColQComparator() {
        }

        @Override
        public int compare(Key k1, Key k2) {
            return k1.compareTo(k2, PartialKey.ROW_COLFAM_COLQUAL);
        }
    }
}

