/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.EnumSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SplitCancelsMajCIT
extends SharedMiniClusterBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitCancelsMajCIT.getClientProps()).build();){
            c.tableOperations().create(tableName);
            IteratorSetting it = new IteratorSetting(100, SlowIterator.class);
            SlowIterator.setSleepTime(it, 500L);
            c.tableOperations().attachIterator(tableName, it, EnumSet.of(IteratorUtil.IteratorScope.majc));
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 100; ++i) {
                    Mutation m = new Mutation((CharSequence)("" + i));
                    m.put((CharSequence)"", (CharSequence)"", new Value());
                    bw.addMutation(m);
                }
                bw.flush();
            }
            AtomicReference ex = new AtomicReference();
            Thread thread = new Thread(() -> {
                try {
                    c.tableOperations().compact(tableName, null, null, true, true);
                }
                catch (Exception e) {
                    ex.set(e);
                }
            });
            thread.start();
            long now = System.currentTimeMillis();
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            partitionKeys.add(new Text("10"));
            c.tableOperations().addSplits(tableName, partitionKeys);
            thread.join();
            Assert.assertTrue((System.currentTimeMillis() - now > 59000L ? 1 : 0) != 0);
            if (ex.get() != null) {
                throw (Exception)ex.get();
            }
        }
    }
}

