/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.StandaloneAccumuloClusterConfiguration;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.FairVolumeChooser;
import org.apache.accumulo.test.ShellServerIT;
import org.apache.accumulo.test.VolumeChooserIT;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShellConfigIT
extends AccumuloClusterHarness {
    private String origPropValue;

    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Before
    public void checkProperty() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellConfigIT.getClientProps()).build();){
            this.origPropValue = (String)client.instanceOperations().getSystemConfiguration().get(VolumeChooserIT.PERTABLE_CHOOSER_PROP);
            client.instanceOperations().setProperty(VolumeChooserIT.PERTABLE_CHOOSER_PROP, FairVolumeChooser.class.getName());
        }
    }

    @After
    public void resetProperty() throws Exception {
        if (this.origPropValue != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellConfigIT.getClientProps()).build();){
                client.instanceOperations().setProperty(VolumeChooserIT.PERTABLE_CHOOSER_PROP, this.origPropValue);
            }
        }
    }

    @Test
    public void experimentalPropTest() throws Exception {
        AuthenticationToken token = ShellConfigIT.getAdminToken();
        File clientPropsFile = null;
        switch (ShellConfigIT.getClusterType()) {
            case MINI: {
                MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)ShellConfigIT.getCluster();
                clientPropsFile = mac.getConfig().getClientPropsFile();
                break;
            }
            case STANDALONE: {
                StandaloneAccumuloClusterConfiguration standaloneConf = (StandaloneAccumuloClusterConfiguration)ShellConfigIT.getClusterConfiguration();
                clientPropsFile = standaloneConf.getClientPropsFile();
                break;
            }
            default: {
                Assert.fail((String)"Unknown cluster type");
            }
        }
        Assert.assertNotNull(clientPropsFile);
        ShellServerIT.TestShell ts = null;
        if (token instanceof PasswordToken) {
            String passwd = new String(((PasswordToken)token).getPassword(), StandardCharsets.UTF_8);
            ts = new ShellServerIT.TestShell(ShellConfigIT.getAdminPrincipal(), passwd, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientPropsFile);
        } else if (token instanceof KerberosToken) {
            ts = new ShellServerIT.TestShell(ShellConfigIT.getAdminPrincipal(), null, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientPropsFile);
        } else {
            Assert.fail((String)"Unknown token type");
        }
        Assert.assertTrue((boolean)Property.INSTANCE_CRYPTO_PREFIX.isExperimental());
        Assert.assertTrue((boolean)Property.INSTANCE_CRYPTO_SERVICE.isExperimental());
        String configOutput = ts.exec("config");
        Assert.assertTrue((boolean)configOutput.contains(VolumeChooserIT.PERTABLE_CHOOSER_PROP));
        Assert.assertFalse((boolean)configOutput.contains(Property.INSTANCE_CRYPTO_SERVICE.getKey()));
    }
}

