/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NewTableConfigurationIT
extends SharedMiniClusterBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 30;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testSetPropertiesOverwriteOlderProperties() throws AccumuloSecurityException, AccumuloException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, String> initialProps = new HashMap<String, String>();
            initialProps.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1", "val1");
            initialProps.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2", "val2");
            ntc.setProperties(initialProps);
            HashMap<String, String> updatedProps = new HashMap<String, String>();
            updatedProps.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop1", "newerval1");
            updatedProps.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop2", "newerval2");
            ntc.setProperties(updatedProps);
            client.tableOperations().create(tableName, ntc);
            Map props = ntc.getProperties();
            Assert.assertEquals(props.get(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop1"), (Object)"newerval1");
            Assert.assertEquals(props.get(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "newerprop2"), (Object)"newerval2");
            Assert.assertFalse((boolean)props.keySet().contains(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1"));
            Assert.assertFalse((boolean)props.keySet().contains(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOverlappingGroupsFail() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
        lgroups.put("lg1", ImmutableSet.of((Object)new Text("colFamA"), (Object)new Text("colFamB")));
        lgroups.put("lg2", ImmutableSet.of((Object)new Text("colFamC"), (Object)new Text("colFamB")));
        ntc.setLocalityGroups(lgroups);
    }

    @Test
    public void testSimpleLocalityGroupCreation() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lg1", ImmutableSet.of((Object)new Text("dog"), (Object)new Text("cat")));
            lgroups.put("lg2", ImmutableSet.of((Object)new Text("lion"), (Object)new Text("tiger")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)2L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lg1"), (Object)ImmutableSet.of((Object)new Text("dog"), (Object)new Text("cat")));
            Assert.assertEquals(createdLocalityGroups.get("lg2"), (Object)ImmutableSet.of((Object)new Text("lion"), (Object)new Text("tiger")));
        }
    }

    @Test
    public void testMulitpleCallsToSetLocalityGroups() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, ImmutableSet> initalGroup = new HashMap<String, ImmutableSet>();
            initalGroup.put("lg1", ImmutableSet.of((Object)new Text("dog"), (Object)new Text("cat")));
            ntc.setLocalityGroups(initalGroup);
            HashMap<String, ImmutableSet> secondGroup = new HashMap<String, ImmutableSet>();
            secondGroup.put("lg1", ImmutableSet.of((Object)new Text("blue"), (Object)new Text("red")));
            ntc.setLocalityGroups(secondGroup);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)1L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lg1"), (Object)ImmutableSet.of((Object)new Text("red"), (Object)new Text("blue")));
        }
    }

    @Test
    public void testSetPropertiesAndGroups() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1", "val1");
            props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2", "val2");
            ntc.setProperties(props);
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lg1", ImmutableSet.of((Object)new Text("dog")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals("table.group.lg1")) {
                    Assert.assertEquals(property.getValue(), (Object)"dog");
                    ++count;
                }
                if (((String)property.getKey()).equals("table.groups.enabled")) {
                    Assert.assertEquals(property.getValue(), (Object)"lg1");
                    ++count;
                }
                if (((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) {
                    Assert.assertEquals(property.getValue(), (Object)"val1");
                    ++count;
                }
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")) continue;
                Assert.assertEquals(property.getValue(), (Object)"val2");
                ++count;
            }
            Assert.assertEquals((long)4L, (long)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)1L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lg1"), (Object)ImmutableSet.of((Object)new Text("dog")));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTablePropertiesSet() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1", "val1");
        props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2", "val2");
        ntc.setProperties(props);
        props.put("invalidProp1", "value1");
        props.put("invalidProp2", "value2");
        ntc.setProperties(props);
    }

    @Test
    public void testSetGroupsWithoutDefaultIterators() throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators();
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lg1", ImmutableSet.of((Object)new Text("colF")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)1L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lg1"), (Object)ImmutableSet.of((Object)new Text("colF")));
            Map iterators = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)0L, (long)iterators.size());
        }
    }

    @Test
    public void testPreconfigureIteratorWithDefaultIterator1() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.attachIterator(new IteratorSetting(10, "anIterator", "it.class", Collections.emptyMap()), EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)2L, (long)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.anIterator=10,it.class"}, true);
            client.tableOperations().removeIterator(tableName, "anIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)1L, (long)iteratorList.size());
        }
    }

    @Test
    public void testPreconfiguredIteratorWithDefaultIterator2() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)2L, (long)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.allOf(IteratorUtil.IteratorScope.class));
            this.verifyIterators(client, tableName, new String[0], true);
            Map iteratorList2 = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)1L, (long)iteratorList2.size());
        }
    }

    @Test
    public void testPreconfiguredIteratorWithDefaultIterator3() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)2L, (long)iteratorList.size());
            Assert.assertEquals(iteratorList.get("someName"), EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)1L, (long)iteratorList.size());
        }
    }

    @Test
    public void testSettingInitialIteratorWithAdditionalIteratorOptions() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            setting.addOptions(Collections.singletonMap("key", "value"));
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar", "table.iterator.scan.someName.opt.key=value"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testSetIteratorWithoutDefaultIterators() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators();
            IteratorSetting setting = new IteratorSetting(10, "myIterator", "my.class");
            ntc.attachIterator(setting);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)1L, (long)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.myIterator=10,my.class"}, false);
            client.tableOperations().removeIterator(tableName, "myIterator", EnumSet.allOf(IteratorUtil.IteratorScope.class));
            this.verifyIterators(client, tableName, new String[0], false);
            Map iteratorList2 = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)0L, (long)iteratorList2.size());
        }
    }

    @Test
    public void testSettingIteratorAndProperties() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1", "val1");
            props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2", "val2");
            ntc.setProperties(props);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) {
                    Assert.assertEquals(property.getValue(), (Object)"val1");
                    ++count;
                }
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop2")) continue;
                Assert.assertEquals(property.getValue(), (Object)"val2");
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIteratorConflictFound1() throws AccumuloException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            setting = new IteratorSetting(12, "someName", "foo2.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIteratorConflictFound2() throws AccumuloException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            setting = new IteratorSetting(10, "anotherName", "foo2.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIteratorConflictFound3() throws AccumuloException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            setting = new IteratorSetting(12, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
        }
    }

    @Test
    public void testMultipleIteratorValid() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "firstIterator", "first.class");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            setting = new IteratorSetting(11, "secondIterator", "second.class");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().create(tableName, ntc);
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.firstIterator=10,first.class", "table.iterator.scan.secondIterator=11,second.class"}, true);
            client.tableOperations().removeIterator(tableName, "firstIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.secondIterator=11,second.class"}, true);
            client.tableOperations().removeIterator(tableName, "secondIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testGroupsIteratorAndPropsTogether() throws AccumuloException, TableNotFoundException, AccumuloSecurityException, TableExistsException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1", "val1");
            ntc.setProperties(props);
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lg1", ImmutableSet.of((Object)new Text("colF")));
            ntc.setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (!((String)property.getKey()).equals(Property.TABLE_ARBITRARY_PROP_PREFIX.getKey() + "prop1")) continue;
                Assert.assertEquals(property.getValue(), (Object)"val1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)1L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lg1"), (Object)ImmutableSet.of((Object)new Text("colF")));
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.someName=10,foo.bar"}, true);
            client.tableOperations().removeIterator(tableName, "someName", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], true);
        }
    }

    @Test
    public void testNtcChaining() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(NewTableConfigurationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(2)[0];
            IteratorSetting setting = new IteratorSetting(10, "anIterator", "it.class", Collections.emptyMap());
            HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
            lgroups.put("lgp", ImmutableSet.of((Object)new Text("col")));
            NewTableConfiguration ntc = new NewTableConfiguration().withoutDefaultIterators().attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan)).setLocalityGroups(lgroups);
            client.tableOperations().create(tableName, ntc);
            Map iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)1L, (long)iteratorList.size());
            this.verifyIterators(client, tableName, new String[]{"table.iterator.scan.anIterator=10,it.class"}, false);
            client.tableOperations().removeIterator(tableName, "anIterator", EnumSet.of(IteratorUtil.IteratorScope.scan));
            this.verifyIterators(client, tableName, new String[0], false);
            iteratorList = client.tableOperations().listIterators(tableName);
            Assert.assertEquals((long)0L, (long)iteratorList.size());
            int count = 0;
            for (Map.Entry property : client.tableOperations().getProperties(tableName)) {
                if (((String)property.getKey()).equals("table.group.lgp")) {
                    Assert.assertEquals(property.getValue(), (Object)"col");
                    ++count;
                }
                if (!((String)property.getKey()).equals("table.groups.enabled")) continue;
                Assert.assertEquals(property.getValue(), (Object)"lgp");
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
            Map createdLocalityGroups = client.tableOperations().getLocalityGroups(tableName);
            Assert.assertEquals((long)1L, (long)createdLocalityGroups.size());
            Assert.assertEquals(createdLocalityGroups.get("lgp"), (Object)ImmutableSet.of((Object)new Text("col")));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPropertiesDisjointCheck() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
        lgroups.put("lg1", ImmutableSet.of((Object)new Text("dog")));
        ntc.setLocalityGroups(lgroups);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("table.key1", "val1");
        props.put("table.group.lg1", "cat");
        ntc.setProperties(props);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLocalityGroupsDisjointCheck() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("table.group.lg1", "cat");
        ntc.setProperties(props);
        HashMap<String, ImmutableSet> lgroups = new HashMap<String, ImmutableSet>();
        lgroups.put("lg1", ImmutableSet.of((Object)new Text("dog")));
        ntc.setLocalityGroups(lgroups);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttachIteratorDisjointCheck() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("table.iterator.scan.someName", "10");
        ntc.setProperties(props);
        IteratorSetting setting = new IteratorSetting(10, "someName", "foo.bar");
        ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
    }

    private void verifyIterators(AccumuloClient client, String tablename, String[] values, boolean withDefaultIts) throws AccumuloException, TableNotFoundException {
        TreeMap<String, String> expected = new TreeMap<String, String>();
        if (withDefaultIts) {
            expected.put("table.iterator.scan.vers", "20,org.apache.accumulo.core.iterators.user.VersioningIterator");
            expected.put("table.iterator.scan.vers.opt.maxVersions", "1");
        }
        for (String value : values) {
            String[] parts = value.split("=", 2);
            expected.put(parts[0], parts[1]);
        }
        TreeMap<String, String> actual = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.getProperties(client, tablename).entrySet()) {
            if (!entry.getKey().contains("table.iterator.scan.")) continue;
            actual.put(entry.getKey(), entry.getValue());
        }
        Assert.assertEquals(expected, actual);
    }

    private Map<String, String> getProperties(AccumuloClient accumuloClient, String tableName) throws AccumuloException, TableNotFoundException {
        Iterable properties = accumuloClient.tableOperations().getProperties(tableName);
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry entry : properties) {
            propertyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return propertyMap;
    }
}

