/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Writer;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.junit.Test;

public class MetaConstraintRetryIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Test(expected=ConstraintViolationException.class)
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MetaConstraintRetryIT.getClientProps()).build();){
            client.securityOperations().grantTablePermission(MetaConstraintRetryIT.getAdminPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
            ServerContext context = MetaConstraintRetryIT.getServerContext();
            Writer w = new Writer((ClientContext)context, MetadataTable.ID);
            KeyExtent extent = new KeyExtent(TableId.of((String)"5"), null, null);
            Mutation m = new Mutation(extent.getMetadataEntry());
            m.put((CharSequence)"badcolfam", (CharSequence)"badcolqual", (CharSequence)"3");
            try {
                MetadataTableUtil.update((ServerContext)context, (Writer)w, null, (Mutation)m);
            }
            catch (RuntimeException e) {
                if (e.getCause().getClass().equals(ConstraintViolationException.class)) {
                    throw (ConstraintViolationException)e.getCause();
                }
            }
        }
    }
}

