/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.Locations;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class LocatorIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private void assertContains(Locations locations, HashSet<String> tservers, Map<Range, ImmutableSet<TabletId>> expected1, Map<TabletId, ImmutableSet<Range>> expected2) {
        HashMap gbr = new HashMap();
        for (Map.Entry entry : locations.groupByRange().entrySet()) {
            gbr.put((Range)entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        Assert.assertEquals(expected1, gbr);
        HashMap gbt = new HashMap();
        for (Map.Entry entry : locations.groupByTablet().entrySet()) {
            gbt.put((TabletId)entry.getKey(), new HashSet((Collection)entry.getValue()));
            TabletId tid = (TabletId)entry.getKey();
            String location = locations.getTabletLocation(tid);
            Assert.assertNotNull((String)("Location for " + tid + " was null"), (Object)location);
            Assert.assertTrue((String)("Unknown location " + location), (boolean)tservers.contains(location));
            Assert.assertEquals((String)("Expected <host>:<port> " + location), (long)2L, (long)location.split(":").length);
        }
        Assert.assertEquals(expected2, gbt);
    }

    private static TabletId newTabletId(String tableId, String endRow, String prevRow) {
        return new TabletIdImpl(new KeyExtent(TableId.of((String)tableId), endRow == null ? null : new Text(endRow), prevRow == null ? null : new Text(prevRow)));
    }

    @Test
    public void testBasic() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(LocatorIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            Range r1 = new Range((CharSequence)"m");
            Range r2 = new Range((CharSequence)"o", (CharSequence)"x");
            String tableId = (String)client.tableOperations().tableIdMap().get(tableName);
            TabletId t1 = LocatorIT.newTabletId(tableId, null, null);
            TabletId t2 = LocatorIT.newTabletId(tableId, "r", null);
            TabletId t3 = LocatorIT.newTabletId(tableId, null, "r");
            ArrayList<Range> ranges = new ArrayList<Range>();
            HashSet<String> tservers = new HashSet<String>(client.instanceOperations().getTabletServers());
            ranges.add(r1);
            Locations ret = client.tableOperations().locate(tableName, ranges);
            this.assertContains(ret, tservers, (Map<Range, ImmutableSet<TabletId>>)ImmutableMap.of((Object)r1, (Object)ImmutableSet.of((Object)t1)), (Map<TabletId, ImmutableSet<Range>>)ImmutableMap.of((Object)t1, (Object)ImmutableSet.of((Object)r1)));
            ranges.add(r2);
            ret = client.tableOperations().locate(tableName, ranges);
            this.assertContains(ret, tservers, (Map<Range, ImmutableSet<TabletId>>)ImmutableMap.of((Object)r1, (Object)ImmutableSet.of((Object)t1), (Object)r2, (Object)ImmutableSet.of((Object)t1)), (Map<TabletId, ImmutableSet<Range>>)ImmutableMap.of((Object)t1, (Object)ImmutableSet.of((Object)r1, (Object)r2)));
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("r"));
            client.tableOperations().addSplits(tableName, splits);
            ret = client.tableOperations().locate(tableName, ranges);
            this.assertContains(ret, tservers, (Map<Range, ImmutableSet<TabletId>>)ImmutableMap.of((Object)r1, (Object)ImmutableSet.of((Object)t2), (Object)r2, (Object)ImmutableSet.of((Object)t2, (Object)t3)), (Map<TabletId, ImmutableSet<Range>>)ImmutableMap.of((Object)t2, (Object)ImmutableSet.of((Object)r1, (Object)r2), (Object)t3, (Object)ImmutableSet.of((Object)r2)));
            client.tableOperations().offline(tableName, true);
            try {
                client.tableOperations().locate(tableName, ranges);
                Assert.fail();
            }
            catch (TableOfflineException tableOfflineException) {
                // empty catch block
            }
            client.tableOperations().delete(tableName);
            try {
                client.tableOperations().locate(tableName, ranges);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }
}

