/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class KeyValueEqualityIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testEquality() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(KeyValueEqualityIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(2);
            String table1 = tables[0];
            String table2 = tables[1];
            TableOperations tops = client.tableOperations();
            tops.create(table1);
            tops.create(table2);
            try (BatchWriter bw1 = client.createBatchWriter(table1);
                 BatchWriter bw2 = client.createBatchWriter(table2);){
                for (int row = 0; row < 100; ++row) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(row));
                    for (int col = 0; col < 10; ++col) {
                        m.put((CharSequence)Integer.toString(col), (CharSequence)"", System.currentTimeMillis(), (CharSequence)Integer.toString(col * 2));
                    }
                    bw1.addMutation(m);
                    bw2.addMutation(m);
                }
            }
            Iterator t1 = client.createScanner(table1, Authorizations.EMPTY).iterator();
            Iterator t2 = client.createScanner(table2, Authorizations.EMPTY).iterator();
            while (t1.hasNext() && t2.hasNext()) {
                Map.Entry e1 = (Map.Entry)t1.next();
                Map.Entry e2 = (Map.Entry)t2.next();
                Assert.assertEquals((Object)e1, (Object)e2);
                Assert.assertEquals((long)e1.hashCode(), (long)e2.hashCode());
            }
            Assert.assertFalse((String)"table1 had more data to read", (boolean)t1.hasNext());
            Assert.assertFalse((String)"table2 had more data to read", (boolean)t2.hasNext());
        }
    }
}

