/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IteratorEnvIT
extends AccumuloClusterHarness {
    private AccumuloClient client;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private static void testEnv(IteratorUtil.IteratorScope scope, Map<String, String> opts, IteratorEnvironment env) {
        TableId expectedTableId = TableId.of((String)opts.get("expected.table.id"));
        if (!"value1".equals(env.getConfig().get("table.custom.iterator.env.test")) && !"value1".equals(env.getServiceEnv().getConfiguration(env.getTableId()).getTableCustom("iterator.env.test"))) {
            throw new RuntimeException("Test failed - Expected table property not found.");
        }
        if (!scope.equals((Object)env.getIteratorScope())) {
            throw new RuntimeException("Test failed - Error getting iterator scope");
        }
        if (env.isSamplingEnabled()) {
            throw new RuntimeException("Test failed - isSamplingEnabled returned true, expected false");
        }
        if (!expectedTableId.equals((Object)env.getTableId())) {
            throw new RuntimeException("Test failed - Error getting Table ID");
        }
    }

    @Before
    public void setup() {
        this.client = (AccumuloClient)Accumulo.newClient().from(IteratorEnvIT.getClientProps()).build();
    }

    @After
    public void finish() {
        this.client.close();
    }

    @Test
    public void test() throws Exception {
        String[] tables = this.getUniqueNames(3);
        this.testScan(tables[0], ScanIter.class);
        this.testCompact(tables[1], MajcIter.class);
        this.testMinCompact(tables[2], MincIter.class);
    }

    private void testScan(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        try (Scanner scan = this.client.createScanner(tableName);){
            scan.addScanIterator(cfg);
            Iterator iter = scan.iterator();
            iter.forEachRemaining(e -> Assert.assertEquals((Object)"cf1", (Object)((Key)e.getKey()).getColumnFamily().toString()));
        }
    }

    public void testCompact(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        CompactionConfig config = new CompactionConfig();
        config.setIterators(Collections.singletonList(cfg));
        this.client.tableOperations().compact(tableName, config);
    }

    public void testMinCompact(String tableName, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) throws Exception {
        this.writeData(tableName);
        IteratorSetting cfg = new IteratorSetting(1, iteratorClass);
        cfg.addOption("expected.table.id", (String)this.client.tableOperations().tableIdMap().get(tableName));
        this.client.tableOperations().attachIterator(tableName, cfg, EnumSet.of(IteratorUtil.IteratorScope.minc));
        this.client.tableOperations().flush(tableName);
    }

    private NewTableConfiguration getTableConfig() {
        NewTableConfiguration ntc = new NewTableConfiguration();
        ntc.setProperties(Collections.singletonMap("table.custom.iterator.env.test", "value1"));
        return ntc;
    }

    private void writeData(String tableName) throws Exception {
        this.client.tableOperations().create(tableName, this.getTableConfig());
        try (BatchWriter bw = this.client.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"row1");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val1");
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row2");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val2");
            bw.addMutation(m);
            m = new Mutation((CharSequence)"row3");
            m.at().family((CharSequence)"cf1").qualifier((CharSequence)"cq1").put((CharSequence)"val3");
            bw.addMutation(m);
        }
    }

    public static class MincIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.minc;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
                throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    env.isFullMajorCompaction();
                    throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
                }
                catch (IllegalStateException illegalStateException2) {
                    return;
                }
            }
        }
    }

    public static class MajcIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.majc;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Test failed");
            }
            try {
                env.isFullMajorCompaction();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Test failed");
            }
        }
    }

    public static class ScanIter
    extends WrappingIterator {
        IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.scan;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvIT.testEnv(this.scope, options, env);
            try {
                env.isUserCompaction();
                throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    env.isFullMajorCompaction();
                    throw new RuntimeException("Test failed - Expected to throw IllegalStateException when checking compaction on a scan.");
                }
                catch (IllegalStateException illegalStateException2) {
                    return;
                }
            }
        }
    }
}

