/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ImportExportIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testExportImportThenScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ImportExportIT.getClientProps()).build();){
            String line;
            String[] tableNames = this.getUniqueNames(2);
            String srcTable = tableNames[0];
            String destTable = tableNames[1];
            client.tableOperations().create(srcTable);
            try (BatchWriter bw = client.createBatchWriter(srcTable);){
                for (int row = 0; row < 1000; ++row) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(row));
                    for (int col = 0; col < 100; ++col) {
                        m.put((CharSequence)Integer.toString(col), (CharSequence)"", (CharSequence)Integer.toString(col * 2));
                    }
                    bw.addMutation(m);
                }
            }
            client.tableOperations().compact(srcTable, null, null, true, true);
            FileSystem fs = cluster.getFileSystem();
            Path tmp = cluster.getTemporaryPath();
            log.info("Using FileSystem: " + fs);
            Path baseDir = new Path(fs.getUri().toString() + tmp, this.getClass().getName());
            fs.deleteOnExit(baseDir);
            if (fs.exists(baseDir)) {
                log.info("{} exists on filesystem, deleting", (Object)baseDir);
                Assert.assertTrue((String)("Failed to deleted " + baseDir), (boolean)fs.delete(baseDir, true));
            }
            log.info("Creating {}", (Object)baseDir);
            Assert.assertTrue((String)("Failed to create " + baseDir), (boolean)fs.mkdirs(baseDir));
            Path exportDir = new Path(baseDir, "export");
            fs.deleteOnExit(exportDir);
            Path importDir = new Path(baseDir, "import");
            fs.deleteOnExit(importDir);
            for (Path p : new Path[]{exportDir, importDir}) {
                Assert.assertTrue((String)("Failed to create " + baseDir), (boolean)fs.mkdirs(p));
            }
            log.info("Exporting table to {}", (Object)exportDir);
            log.info("Importing table from {}", (Object)importDir);
            client.tableOperations().offline(srcTable, true);
            client.tableOperations().exportTable(srcTable, exportDir.toString());
            Path distcp = new Path(exportDir, "distcp.txt");
            fs.deleteOnExit(distcp);
            Assert.assertTrue((String)"Distcp file doesn't exist", (boolean)fs.exists(distcp));
            FSDataInputStream is = fs.open(distcp);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            while ((line = reader.readLine()) != null) {
                Path p = new Path(line.substring(5));
                Assert.assertTrue((String)("File doesn't exist: " + p), (boolean)fs.exists(p));
                Path dest = new Path(importDir, p.getName());
                Assert.assertFalse((String)("Did not expect " + dest + " to exist"), (boolean)fs.exists(dest));
                FileUtil.copy((FileSystem)fs, (Path)p, (FileSystem)fs, (Path)dest, (boolean)false, (Configuration)fs.getConf());
            }
            reader.close();
            log.info("Import dir: {}", (Object)Arrays.toString(fs.listStatus(importDir)));
            client.tableOperations().importTable(destTable, importDir.toString());
            String tableId = (String)client.tableOperations().tableIdMap().get(destTable);
            Assert.assertNotNull((Object)tableId);
            log.info("Imported into table with ID: {}", (Object)tableId);
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.TabletsSection.getRange((TableId)TableId.of((String)tableId)));
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)s);
                for (Map.Entry fileEntry : s) {
                    Key k = (Key)fileEntry.getKey();
                    String value = ((Value)fileEntry.getValue()).toString();
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        String fileUri = k.getColumnQualifier().toString();
                        Assert.assertFalse((String)("Imported files should have absolute URIs, not relative: " + fileUri), (boolean)this.looksLikeRelativePath(fileUri));
                        continue;
                    }
                    if (k.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.ServerColumnFamily.NAME)) {
                        Assert.assertFalse((String)("Server directory should have absolute URI, not relative: " + value), (boolean)this.looksLikeRelativePath(value));
                        continue;
                    }
                    Assert.fail((String)("Got expected pair: " + k + "=" + fileEntry.getValue()));
                }
            }
            client.tableOperations().online(srcTable, true);
            this.verifyTableEquality(client, srcTable, destTable);
        }
    }

    private void verifyTableEquality(AccumuloClient client, String srcTable, String destTable) throws Exception {
        Iterator src = client.createScanner(srcTable, Authorizations.EMPTY).iterator();
        Iterator dest = client.createScanner(destTable, Authorizations.EMPTY).iterator();
        Assert.assertTrue((String)"Could not read any data from source table", (boolean)src.hasNext());
        Assert.assertTrue((String)"Could not read any data from destination table", (boolean)dest.hasNext());
        while (src.hasNext() && dest.hasNext()) {
            Map.Entry orig = (Map.Entry)src.next();
            Map.Entry copy = (Map.Entry)dest.next();
            Assert.assertEquals(orig.getKey(), copy.getKey());
            Assert.assertEquals(orig.getValue(), copy.getValue());
        }
        Assert.assertFalse((String)"Source table had more data to read", (boolean)src.hasNext());
        Assert.assertFalse((String)"Dest table had more data to read", (boolean)dest.hasNext());
    }

    private boolean looksLikeRelativePath(String uri) {
        if (uri.startsWith("/b-")) {
            return uri.charAt(10) == '/';
        }
        return uri.startsWith("/c-");
    }
}

