/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class GenerateSequentialRFile
implements Runnable {
    private static final Text CF = new Text("CF");
    private static final Text CQ = new Text("CQ");
    private final Opts opts;

    public GenerateSequentialRFile(Opts opts) {
        this.opts = opts;
    }

    @Override
    public void run() {
        try {
            Configuration conf = new Configuration();
            Path p = new Path(this.opts.filePath);
            FileSystem fs = p.getFileSystem(conf);
            FileSKVWriter writer = FileOperations.getInstance().newWriterBuilder().forFile(this.opts.filePath, fs, conf, CryptoServiceFactory.newDefaultInstance()).withTableConfiguration((AccumuloConfiguration)DefaultConfiguration.getInstance()).build();
            writer.startDefaultLocalityGroup();
            int x = 0;
            while ((long)x < this.opts.rows) {
                Text row = new Text(String.format("%03d", x));
                int y = 0;
                while ((long)y < this.opts.valuesPerRow) {
                    String suffix = String.format("%05d", y);
                    writer.append(new Key(new Text(row + ":" + suffix), CF, CQ), new Value(suffix.getBytes(StandardCharsets.UTF_8)));
                    ++y;
                }
                ++x;
            }
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(GenerateSequentialRFile.class.getName(), args, new Object[0]);
        new GenerateSequentialRFile(opts).run();
    }

    static class Opts
    extends Help {
        @Parameter(names={"-f", "--file"}, description="Path to the file to create")
        String filePath;
        @Parameter(names={"-nr"}, description="Number of rows")
        long rows = 24L;
        @Parameter(names={"-nv"}, description="Number of values per row")
        long valuesPerRow = 42000L;

        Opts() {
        }
    }
}

