/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.constraints.AlphaNumKeyConstraint;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalWriterIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ConditionalWriterIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new Callback());
    }

    @AfterClass
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    public static long abs(long l) {
        if ((l = Math.abs(l)) < 0L) {
            return 0L;
        }
        return l;
    }

    @Before
    public void deleteUsers() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            Set users = client.securityOperations().listLocalUsers();
            ClusterUser user = this.getUser(0);
            if (users.contains(user.getPrincipal())) {
                client.securityOperations().dropLocalUser(user.getPrincipal());
            }
        }
    }

    @Test
    public void testBasic() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());
                 Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm0.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"doe");
                cm0.put((CharSequence)"name", (CharSequence)"first", (CharSequence)"john");
                cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm1.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"Doe");
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm2.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txtypo", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"doe")});
                cm4.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
                cm5.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"deo");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
                scanner.fetchColumn((CharSequence)"name", (CharSequence)"last");
                scanner.setRange(new Range((CharSequence)"99006"));
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"Doe", (Object)((Value)entry.getValue()).toString());
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"2"), new Condition((CharSequence)"name", (CharSequence)"last").setValue((CharSequence)"Doe")});
                cm6.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"DOE");
                cm6.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"3");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"DOE", (Object)((Value)entry.getValue()).toString());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"3")});
                cm7.putDelete((CharSequence)"name", (CharSequence)"last");
                cm7.putDelete((CharSequence)"name", (CharSequence)"first");
                cm7.putDelete((CharSequence)"tx", (CharSequence)"seq");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
                Assert.assertFalse((String)"Did not expect to find any results", (boolean)scanner.iterator().hasNext());
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"doe", (Object)((Value)entry.getValue()).toString());
            }
        }
    }

    @Test
    public void testFields() throws Exception {
        try (AccumuloClient client1 = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            String user = null;
            ClusterUser user1 = this.getUser(0);
            user = user1.getPrincipal();
            if (ConditionalWriterIT.saslEnabled()) {
                client1.securityOperations().createLocalUser(user, null);
            } else {
                client1.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
            }
            Authorizations auths = new Authorizations(new String[]{"A", "B"});
            client1.securityOperations().changeUserAuthorizations(user, auths);
            client1.securityOperations().grantSystemPermission(user, SystemPermission.CREATE_TABLE);
            try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(client1.properties()).as((CharSequence)user, user1.getToken()).build();){
                client2.tableOperations().create(tableName);
                try (ConditionalWriter cw = client2.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(auths));
                     Scanner scanner = client2.createScanner(tableName, auths);){
                    ColumnVisibility cva = new ColumnVisibility("A");
                    ColumnVisibility cvb = new ColumnVisibility("B");
                    ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                    cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                    cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                    cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
                    scanner.setRange(new Range((CharSequence)"99006"));
                    scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
                    long ts = ((Key)entry.getKey()).getTimestamp();
                    ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"txA", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                    cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
                    ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seqA").setVisibility(cva).setValue((CharSequence)"1")});
                    cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm2).getStatus());
                    ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
                    cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm3).getStatus());
                    ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts + 1L).setValue((CharSequence)"1")});
                    cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm4).getStatus());
                    ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts - 1L).setValue((CharSequence)"1")});
                    cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm5).getStatus());
                    entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
                    ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setTimestamp(ts).setValue((CharSequence)"1")});
                    cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"Doe");
                    cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"John");
                    cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"2");
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                    entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"2", (Object)((Value)entry.getValue()).toString());
                }
            }
        }
    }

    @Test
    public void testBadColVis() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            Authorizations auths = new Authorizations(new String[]{"A", "B"});
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), auths);
            Authorizations filteredAuths = new Authorizations(new String[]{"A"});
            ColumnVisibility cva = new ColumnVisibility("A");
            ColumnVisibility cvb = new ColumnVisibility("B");
            ColumnVisibility cvc = new ColumnVisibility("C");
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(filteredAuths));){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb)});
                cm0.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm0.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm0.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm0).getStatus());
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1")});
                cm1.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm1.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm1.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc)});
                cm2.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm2.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm2.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm2).getStatus());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvc).setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm3.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm3).getStatus());
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                cm4.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm4.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm4).getStatus());
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm5.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm5.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm5).getStatus());
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb).setValue((CharSequence)"1"), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva)});
                cm6.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm6.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm6.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm6).getStatus());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm7.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm7.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm7.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)cw.write(cm7).getStatus());
            }
            Authorizations exceedingAuths = new Authorizations(new String[]{"A", "B", "D"});
            try (ConditionalWriter cw2 = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(exceedingAuths));){
                ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvb), new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cva).setValue((CharSequence)"1")});
                cm8.put((CharSequence)"name", (CharSequence)"last", cva, (CharSequence)"doe");
                cm8.put((CharSequence)"name", (CharSequence)"first", cva, (CharSequence)"john");
                cm8.put((CharSequence)"tx", (CharSequence)"seq", cva, (CharSequence)"1");
                try {
                    ConditionalWriter.Status status = cw2.write(cm8).getStatus();
                    Assert.fail((String)("Writing mutation with Authorizations the user doesn't have should fail. Got status: " + status));
                }
                catch (AccumuloSecurityException accumuloSecurityException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testConstraints() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
            client.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
            try (ConditionalWriter cw = client.createConditionalWriter(tableName + "_clone", new ConditionalWriterConfig());
                 Scanner scanner = client.createScanner(tableName + "_clone", new Authorizations());){
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006+", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)cw.write(cm0).getStatus());
                Assert.assertFalse((String)"Should find no results in the table is mutation result was violated", (boolean)scanner.iterator().hasNext());
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                Assert.assertTrue((String)"Accepted result should be returned when reading table", (boolean)scanner.iterator().hasNext());
            }
        }
    }

    @Test
    public void testIterators() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName, new NewTableConfiguration().withoutDefaultIterators());
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1001");
                m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1002");
                m.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                bw.addMutation(m);
                bw.addMutation(m);
            }
            IteratorSetting iterConfig = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)iterConfig, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)iterConfig, Collections.singletonList(new IteratorSetting.Column("count")));
            IteratorSetting iterConfig2 = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)iterConfig2, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)iterConfig2, Collections.singletonList(new IteratorSetting.Column("count2", "comments")));
            IteratorSetting iterConfig3 = new IteratorSetting(5, VersioningIterator.class);
            VersioningIterator.setMaxVersions((IteratorSetting)iterConfig3, (int)1);
            try (Scanner scanner = client.createScanner(tableName, new Authorizations());){
                scanner.addScanIterator(iterConfig);
                scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
                scanner.fetchColumn((CharSequence)"count", (CharSequence)"comments");
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"3", (Object)((Value)entry.getValue()).toString());
                try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());){
                    ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"3")});
                    cm0.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm0).getStatus());
                    entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"3", (Object)((Value)entry.getValue()).toString());
                    ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"3")});
                    cm1.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                    entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"4", (Object)((Value)entry.getValue()).toString());
                    ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"4")});
                    cm2.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)cw.write(cm1).getStatus());
                    entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"4", (Object)((Value)entry.getValue()).toString());
                    ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig}).setValue((CharSequence)"4")});
                    cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"1");
                    ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2}).setValue((CharSequence)"2")});
                    cm4.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                    ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count2", (CharSequence)"comments").setIterators(new IteratorSetting[]{iterConfig2, iterConfig3}).setValue((CharSequence)"2")});
                    cm5.put((CharSequence)"count2", (CharSequence)"comments", (CharSequence)"1");
                    Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
                    HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
                    while (results.hasNext()) {
                        ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                        String k = new String(result.getMutation().getRow());
                        Assert.assertFalse((String)("Did not expect to see multiple resultus for the row: " + k), (boolean)actual.containsKey(k));
                        actual.put(k, result.getStatus());
                    }
                    HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
                    expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
                    expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
                    expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
                    Assert.assertEquals(expected, actual);
                }
            }
        }
    }

    @Test
    public void testTableAndConditionIterators() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            IteratorSetting aiConfig1 = new IteratorSetting(30, "AI1", AddingIterator.class);
            aiConfig1.addOption("amount", "2");
            IteratorSetting aiConfig2 = new IteratorSetting(35, "MI1", MultiplyingIterator.class);
            aiConfig2.addOption("amount", "3");
            IteratorSetting aiConfig3 = new IteratorSetting(40, "AI2", AddingIterator.class);
            aiConfig3.addOption("amount", "5");
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"ACCUMULO-1000");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"6");
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1001");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
                bw.addMutation(m);
                m = new Mutation((CharSequence)"ACCUMULO-1002");
                m.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
                bw.addMutation(m);
            }
            client.tableOperations().attachIterator(tableName, aiConfig1, EnumSet.of(IteratorUtil.IteratorScope.scan));
            client.tableOperations().offline(tableName, true);
            client.tableOperations().online(tableName, true);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());
                 Scanner scanner = client.createScanner(tableName, new Authorizations());){
                ConditionalMutation cm6 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setValue((CharSequence)"8")});
                cm6.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"7");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm6).getStatus());
                scanner.setRange(new Range((CharSequence)"ACCUMULO-1000"));
                scanner.fetchColumn((CharSequence)"count", (CharSequence)"comments");
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"9", (Object)((Value)entry.getValue()).toString());
                ConditionalMutation cm7 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"27")});
                cm7.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"8");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm7).getStatus());
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"10", (Object)((Value)entry.getValue()).toString());
                ConditionalMutation cm8 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2, aiConfig3}).setValue((CharSequence)"35")});
                cm8.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"9");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm8).getStatus());
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"11", (Object)((Value)entry.getValue()).toString());
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"ACCUMULO-1000", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig2}).setValue((CharSequence)"33")});
                cm3.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"ACCUMULO-1001", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"14")});
                cm4.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"ACCUMULO-1002", new Condition[]{new Condition((CharSequence)"count", (CharSequence)"comments").setIterators(new IteratorSetting[]{aiConfig3}).setValue((CharSequence)"10")});
                cm5.put((CharSequence)"count", (CharSequence)"comments", (CharSequence)"3");
                Iterator results = cw.write(Arrays.asList(cm3, cm4, cm5).iterator());
                HashMap<String, ConditionalWriter.Status> actual = new HashMap<String, ConditionalWriter.Status>();
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    String k = new String(result.getMutation().getRow());
                    Assert.assertFalse((String)("Did not expect to see multiple resultus for the row: " + k), (boolean)actual.containsKey(k));
                    actual.put(k, result.getStatus());
                }
                HashMap<String, ConditionalWriter.Status> expected = new HashMap<String, ConditionalWriter.Status>();
                expected.put("ACCUMULO-1000", ConditionalWriter.Status.ACCEPTED);
                expected.put("ACCUMULO-1001", ConditionalWriter.Status.ACCEPTED);
                expected.put("ACCUMULO-1002", ConditionalWriter.Status.REJECTED);
                Assert.assertEquals(expected, actual);
            }
        }
    }

    @Test
    public void testBatch() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
            ColumnVisibility cvab = new ColumnVisibility("A|B");
            ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm0.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm0);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm1.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jane");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm1);
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
            cm2.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cvab, (CharSequence)"jack");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
            mutations.add(cm2);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));
                 Scanner scanner = client.createScanner(tableName, new Authorizations(new String[]{"A"}));){
                Iterator results = cw.write(mutations.iterator());
                int count = 0;
                while (results.hasNext()) {
                    String[] result = (String[])results.next();
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assert.assertEquals((long)3L, (long)count);
                scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                for (String row : new String[]{"99006", "59056", "19059"}) {
                    scanner.setRange(new Range((CharSequence)row));
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
                }
                TreeSet<Text> splits = new TreeSet<Text>();
                splits.add(new Text("7"));
                splits.add(new Text("3"));
                client.tableOperations().addSplits(tableName, splits);
                mutations.clear();
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"1")});
                cm3.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm3.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"2");
                mutations.add(cm3);
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab)});
                cm4.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm4.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"1");
                mutations.add(cm4);
                ConditionalMutation cm5 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvab).setValue((CharSequence)"2")});
                cm5.put((CharSequence)"name", (CharSequence)"last", cvab, (CharSequence)"Doe");
                cm5.put((CharSequence)"tx", (CharSequence)"seq", cvab, (CharSequence)"3");
                mutations.add(cm5);
                results = cw.write(mutations.iterator());
                int accepted = 0;
                int rejected = 0;
                while (results.hasNext()) {
                    String[] result = (String[])results.next();
                    if (new String(result.getMutation().getRow()).equals("99006")) {
                        Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                        ++accepted;
                        continue;
                    }
                    Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                    ++rejected;
                }
                Assert.assertEquals((String)"Expected only one accepted conditional mutation", (long)1L, (long)accepted);
                Assert.assertEquals((String)"Expected two rejected conditional mutations", (long)2L, (long)rejected);
                for (String row : new String[]{"59056", "19059"}) {
                    scanner.setRange(new Range((CharSequence)row));
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                    Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
                }
                scanner.setRange(new Range((CharSequence)"99006"));
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"2", (Object)((Value)entry.getValue()).toString());
                scanner.clearColumns();
                scanner.fetchColumn((CharSequence)"name", (CharSequence)"last");
                entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"Doe", (Object)((Value)entry.getValue()).toString());
            }
        }
    }

    @Test
    public void testBigBatch() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            int i;
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().addSplits(tableName, this.nss("2", "4", "6"));
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            int num = 100;
            ArrayList<byte[]> rows = new ArrayList<byte[]>(num);
            ArrayList<ConditionalMutation> cml = new ArrayList<ConditionalMutation>(num);
            SecureRandom r = new SecureRandom();
            byte[] e = new byte[]{};
            for (i = 0; i < num; ++i) {
                rows.add(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(r.nextLong()), (int)16, (int)16, (byte[])e));
            }
            for (i = 0; i < num; ++i) {
                ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq")});
                cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"1");
                cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
                cml.add(cm);
            }
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());){
                Iterator results = cw.write(cml.iterator());
                int count = 0;
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assert.assertEquals((String)"Did not receive the expected number of results", (long)num, (long)count);
                ArrayList<ConditionalMutation> cml2 = new ArrayList<ConditionalMutation>(num);
                for (int i2 = 0; i2 < num; ++i2) {
                    ConditionalMutation cm = new ConditionalMutation((byte[])rows.get(i2), new Condition[]{new Condition((CharSequence)"meta", (CharSequence)"seq").setValue((CharSequence)"1")});
                    cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)"2");
                    cm.put((CharSequence)"meta", (CharSequence)"tx", (CharSequence)UUID.randomUUID().toString());
                    cml2.add(cm);
                }
                count = 0;
                results = cw.write(cml2.iterator());
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    ++count;
                }
                Assert.assertEquals((String)"Did not receive the expected number of results", (long)num, (long)count);
            }
        }
    }

    @Test
    public void testBatchErrors() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().addConstraint(tableName, AlphaNumKeyConstraint.class.getName());
            client.tableOperations().clone(tableName, tableName + "_clone", true, new HashMap(), new HashSet());
            client.securityOperations().changeUserAuthorizations(ConditionalWriterIT.getAdminPrincipal(), new Authorizations(new String[]{"A", "B"}));
            ColumnVisibility cvaob = new ColumnVisibility("A|B");
            ColumnVisibility cvaab = new ColumnVisibility("A&B");
            switch (new SecureRandom().nextInt(3)) {
                case 1: {
                    client.tableOperations().addSplits(tableName, this.nss("6"));
                    break;
                }
                case 2: {
                    client.tableOperations().addSplits(tableName, this.nss("2", "95"));
                }
            }
            ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
            ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
            cm0.put((CharSequence)"name+", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm0.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
            cm0.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
            mutations.add(cm0);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"59056", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaab)});
            cm1.put((CharSequence)"name", (CharSequence)"last", cvaab, (CharSequence)"doe");
            cm1.put((CharSequence)"name", (CharSequence)"first", cvaab, (CharSequence)"jane");
            cm1.put((CharSequence)"tx", (CharSequence)"seq", cvaab, (CharSequence)"1");
            mutations.add(cm1);
            ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"19059", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob)});
            cm2.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm2.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"jack");
            cm2.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"1");
            mutations.add(cm2);
            ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"90909", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setVisibility(cvaob).setValue((CharSequence)"1")});
            cm3.put((CharSequence)"name", (CharSequence)"last", cvaob, (CharSequence)"doe");
            cm3.put((CharSequence)"name", (CharSequence)"first", cvaob, (CharSequence)"john");
            cm3.put((CharSequence)"tx", (CharSequence)"seq", cvaob, (CharSequence)"2");
            mutations.add(cm3);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig().setAuthorizations(new Authorizations(new String[]{"A"})));
                 Scanner scanner = client.createScanner(tableName, new Authorizations(new String[]{"A"}));){
                Iterator results = cw.write(mutations.iterator());
                HashSet<String> rows = new HashSet<String>();
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    String row = new String(result.getMutation().getRow());
                    if (row.equals("19059")) {
                        Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    } else if (row.equals("59056")) {
                        Assert.assertEquals((Object)ConditionalWriter.Status.INVISIBLE_VISIBILITY, (Object)result.getStatus());
                    } else if (row.equals("99006")) {
                        Assert.assertEquals((Object)ConditionalWriter.Status.VIOLATED, (Object)result.getStatus());
                    } else if (row.equals("90909")) {
                        Assert.assertEquals((Object)ConditionalWriter.Status.REJECTED, (Object)result.getStatus());
                    }
                    rows.add(row);
                }
                Assert.assertEquals((long)4L, (long)rows.size());
                scanner.fetchColumn((CharSequence)"tx", (CharSequence)"seq");
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)scanner);
                Assert.assertEquals((Object)"1", (Object)((Value)entry.getValue()).toString());
            }
        }
    }

    @Test
    public void testSameRow() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm1).getStatus());
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"c");
                ConditionalMutation cm4 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm4.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm4.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"d");
                Iterator results = cw.write(Arrays.asList(cm2, cm3, cm4).iterator());
                int accepted = 0;
                int rejected = 0;
                int total = 0;
                while (results.hasNext()) {
                    ConditionalWriter.Status status = ((ConditionalWriter.Result)results.next()).getStatus();
                    if (status == ConditionalWriter.Status.ACCEPTED) {
                        ++accepted;
                    }
                    if (status == ConditionalWriter.Status.REJECTED) {
                        ++rejected;
                    }
                    ++total;
                }
                Assert.assertEquals((String)"Expected one accepted result", (long)1L, (long)accepted);
                Assert.assertEquals((String)"Expected two rejected results", (long)2L, (long)rejected);
                Assert.assertEquals((String)"Expected three total results", (long)3L, (long)total);
            }
        }
    }

    @Test
    public void testThreads() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            SecureRandom rand = new SecureRandom();
            switch (rand.nextInt(3)) {
                case 1: {
                    client.tableOperations().addSplits(tableName, this.nss("4"));
                    break;
                }
                case 2: {
                    client.tableOperations().addSplits(tableName, this.nss("3", "5"));
                }
            }
            try (ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());){
                ArrayList<ByteSequence> rows = new ArrayList<ByteSequence>();
                for (int i = 0; i < 1000; ++i) {
                    rows.add((ByteSequence)new ArrayByteSequence(FastFormat.toZeroPaddedString((long)ConditionalWriterIT.abs(rand.nextLong()), (int)16, (int)16, (byte[])new byte[0])));
                }
                ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
                for (ByteSequence row : rows) {
                    mutations.add(new Stats(row).toMutation());
                }
                ArrayList<ArrayByteSequence> rows2 = new ArrayList<ArrayByteSequence>();
                Iterator results = cw.write(mutations.iterator());
                while (results.hasNext()) {
                    ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                    Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)result.getStatus());
                    rows2.add(new ArrayByteSequence(result.getMutation().getRow()));
                }
                Collections.sort(rows);
                Collections.sort(rows2);
                Assert.assertEquals(rows, rows2);
                AtomicBoolean failed = new AtomicBoolean(false);
                ExecutorService tp = Executors.newFixedThreadPool(5);
                for (int i = 0; i < 5; ++i) {
                    tp.submit(new MutatorTask(tableName, client, rows, cw, failed));
                }
                tp.shutdown();
                while (!tp.isTerminated()) {
                    tp.awaitTermination(1L, TimeUnit.MINUTES);
                }
                Assert.assertFalse((String)"A MutatorTask failed with an exception", (boolean)failed.get());
            }
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                RowIterator rowIter = new RowIterator((Iterable)scanner);
                while (rowIter.hasNext()) {
                    Iterator row = rowIter.next();
                    new Stats(row);
                }
            }
        }
    }

    private SortedSet<Text> nss(String ... splits) {
        TreeSet<Text> ret = new TreeSet<Text>();
        for (String split : splits) {
            ret.add(new Text(split));
        }
        return ret;
    }

    @Test
    public void testSecurity() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String user = null;
            ClusterUser user1 = this.getUser(0);
            user = user1.getPrincipal();
            if (ConditionalWriterIT.saslEnabled()) {
                client.securityOperations().createLocalUser(user, null);
            } else {
                client.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)user1.getPassword()));
            }
            String[] tables = this.getUniqueNames(3);
            String table1 = tables[0];
            String table2 = tables[1];
            String table3 = tables[2];
            client.tableOperations().create(table1);
            client.tableOperations().create(table2);
            client.tableOperations().create(table3);
            client.securityOperations().grantTablePermission(user, table1, TablePermission.READ);
            client.securityOperations().grantTablePermission(user, table2, TablePermission.WRITE);
            client.securityOperations().grantTablePermission(user, table3, TablePermission.READ);
            client.securityOperations().grantTablePermission(user, table3, TablePermission.WRITE);
            ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
            cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
            cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
            try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(client.properties()).as((CharSequence)user, user1.getToken()).build();
                 ConditionalWriter cw1 = client2.createConditionalWriter(table1, new ConditionalWriterConfig());
                 ConditionalWriter cw2 = client2.createConditionalWriter(table2, new ConditionalWriterConfig());
                 ConditionalWriter cw3 = client2.createConditionalWriter(table3, new ConditionalWriterConfig());){
                ConditionalWriter.Status status2;
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw3.write(cm1).getStatus());
                try {
                    status2 = cw1.write(cm1).getStatus();
                    Assert.fail((String)("Expected exception writing conditional mutation to table the user doesn't have write access to, Got status: " + status2));
                }
                catch (AccumuloSecurityException status2) {
                    // empty catch block
                }
                try {
                    status2 = cw2.write(cm1).getStatus();
                    Assert.fail((String)("Expected exception writing conditional mutation to table the user doesn't have read access to. Got status: " + status2));
                }
                catch (AccumuloSecurityException accumuloSecurityException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testTimeout() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig().setTimeout(3L, TimeUnit.SECONDS));
                 Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                Assert.assertEquals((Object)cw.write(cm1).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
                IteratorSetting is = new IteratorSetting(5, SlowIterator.class);
                SlowIterator.setSeekSleepTime(is, 5000L);
                ConditionalMutation cm2 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1").setIterators(new IteratorSetting[]{is})});
                cm2.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm2.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                Assert.assertEquals((Object)cw.write(cm2).getStatus(), (Object)ConditionalWriter.Status.UNKNOWN);
                for (Map.Entry entry : scanner) {
                    String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                    String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                    String val = ((Value)entry.getValue()).toString();
                    if (cf.equals("tx") && cq.equals("seq")) {
                        Assert.assertEquals((String)"Unexpected value in tx:seq", (Object)"1", (Object)val);
                        continue;
                    }
                    if (cf.equals("data") && cq.equals("x")) {
                        Assert.assertEquals((String)"Unexpected value in data:x", (Object)"a", (Object)val);
                        continue;
                    }
                    Assert.fail((String)("Saw unexpected column family and qualifier: " + entry));
                }
                ConditionalMutation cm3 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)"1")});
                cm3.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"2");
                cm3.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"b");
                Assert.assertEquals((Object)cw.write(cm3).getStatus(), (Object)ConditionalWriter.Status.ACCEPTED);
            }
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            try {
                client.createConditionalWriter(table, new ConditionalWriterConfig());
                Assert.fail((String)"Creating conditional writer for table that doesn't exist should fail");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig());){
                client.tableOperations().delete(table);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                try {
                    ConditionalWriter.Status status = result.getStatus();
                    Assert.fail((String)("Expected exception writing conditional mutation to deleted table. Got status: " + status));
                }
                catch (AccumuloException ae) {
                    Assert.assertEquals(TableDeletedException.class, ae.getCause().getClass());
                }
            }
        }
    }

    @Test
    public void testOffline() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig());){
                client.tableOperations().offline(table, true);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                try {
                    ConditionalWriter.Status status = result.getStatus();
                    Assert.fail((String)("Expected exception writing conditional mutation to offline table. Got status: " + status));
                }
                catch (AccumuloException ae) {
                    Assert.assertEquals(TableOfflineException.class, ae.getCause().getClass());
                }
                try {
                    client.createConditionalWriter(table, new ConditionalWriterConfig());
                    Assert.fail((String)"Expected exception creating conditional writer to offline table");
                }
                catch (TableOfflineException tableOfflineException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testError() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig());){
                IteratorSetting iterSetting = new IteratorSetting(5, BadIterator.class);
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setIterators(new IteratorSetting[]{iterSetting})});
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                ConditionalWriter.Result result = cw.write(cm1);
                try {
                    ConditionalWriter.Status status = result.getStatus();
                    Assert.fail((String)("Expected exception using iterator which throws an error, Got status: " + status));
                }
                catch (AccumuloException accumuloException) {
                    // empty catch block
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoConditions() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            client.tableOperations().create(table);
            try (ConditionalWriter cw = client.createConditionalWriter(table, new ConditionalWriterConfig());){
                ConditionalMutation cm1 = new ConditionalMutation((CharSequence)"r1", new Condition[0]);
                cm1.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                cm1.put((CharSequence)"data", (CharSequence)"x", (CharSequence)"a");
                cw.write(cm1);
            }
        }
    }

    @Test
    public void testTrace() throws Exception {
        Process tracer = null;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ConditionalWriterIT.getClientProps()).build();){
            long rootTraceId;
            MiniAccumuloClusterImpl mac = ConditionalWriterIT.getCluster();
            if (!client.tableOperations().exists("trace")) {
                tracer = mac.exec(TraceServer.class, new String[0]).getProcess();
                while (!client.tableOperations().exists("trace")) {
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            TraceUtil.enableClientTraces((String)"localhost", (String)"testTrace", (Properties)mac.getClientProperties());
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            try (TraceScope root = Trace.startSpan((String)"traceTest", (Sampler)Sampler.ALWAYS);
                 ConditionalWriter cw = client.createConditionalWriter(tableName, new ConditionalWriterConfig());){
                rootTraceId = root.getSpan().getTraceId();
                ConditionalMutation cm0 = new ConditionalMutation((CharSequence)"99006", new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq")});
                cm0.put((CharSequence)"name", (CharSequence)"last", (CharSequence)"doe");
                cm0.put((CharSequence)"name", (CharSequence)"first", (CharSequence)"john");
                cm0.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)"1");
                Assert.assertEquals((Object)ConditionalWriter.Status.ACCEPTED, (Object)cw.write(cm0).getStatus());
            }
            try (Scanner scanner = client.createScanner("trace", Authorizations.EMPTY);){
                scanner.setRange(new Range(new Text(Long.toHexString(rootTraceId))));
                block21: while (true) {
                    StringBuilder finalBuffer = new StringBuilder();
                    int traceCount = TraceDump.printTrace((Scanner)scanner, line -> {
                        try {
                            finalBuffer.append(line).append("\n");
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                    String traceOutput = finalBuffer.toString();
                    log.info("Trace output:" + traceOutput);
                    if (traceCount > 0) {
                        String[] parts = "traceTest, startScan,startConditionalUpdate,conditionalUpdate,Check conditions,apply conditional mutations".split(",");
                        int lastPos = 0;
                        for (String part : parts) {
                            log.info("Looking in trace output for '" + part + "'");
                            int pos = traceOutput.indexOf(part);
                            if (pos == -1) {
                                log.info("Trace output doesn't contain '" + part + "'");
                                Thread.sleep(1000L);
                                break block21;
                            }
                            Assert.assertTrue((String)("Did not find '" + part + "' in output"), (pos > 0 ? 1 : 0) != 0);
                            Assert.assertTrue((String)("'" + part + "' occurred earlier than the previous element unexpectedly"), (pos > lastPos ? 1 : 0) != 0);
                            lastPos = pos;
                        }
                        break;
                    }
                    log.info("Ignoring trace output as traceCount not greater than zero: " + traceCount);
                    Thread.sleep(1000L);
                }
                if (tracer != null) {
                    tracer.destroy();
                }
            }
        }
    }

    private static class MutatorTask
    implements Runnable {
        String tableName;
        ArrayList<ByteSequence> rows;
        ConditionalWriter cw;
        AccumuloClient client;
        AtomicBoolean failed;

        public MutatorTask(String tableName, AccumuloClient client, ArrayList<ByteSequence> rows, ConditionalWriter cw, AtomicBoolean failed) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
            this.cw = cw;
            this.failed = failed;
        }

        @Override
        public void run() {
            try (IsolatedScanner scanner = new IsolatedScanner(this.client.createScanner(this.tableName, Authorizations.EMPTY));){
                SecureRandom rand = new SecureRandom();
                for (int i = 0; i < 20; ++i) {
                    int numRows = rand.nextInt(10) + 1;
                    ArrayList<ByteSequence> changes = new ArrayList<ByteSequence>(numRows);
                    ArrayList<ConditionalMutation> mutations = new ArrayList<ConditionalMutation>();
                    for (int j = 0; j < numRows; ++j) {
                        changes.add(this.rows.get(rand.nextInt(this.rows.size())));
                    }
                    for (ByteSequence row : changes) {
                        scanner.setRange(new Range((CharSequence)row.toString()));
                        Stats stats = new Stats(scanner.iterator());
                        stats.set(rand.nextInt(10), rand.nextInt(Integer.MAX_VALUE));
                        mutations.add(stats.toMutation());
                    }
                    ArrayList<ArrayByteSequence> changed = new ArrayList<ArrayByteSequence>(numRows);
                    Iterator results = this.cw.write(mutations.iterator());
                    while (results.hasNext()) {
                        ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                        changed.add(new ArrayByteSequence(result.getMutation().getRow()));
                    }
                    Collections.sort(changes);
                    Collections.sort(changed);
                    Assert.assertEquals(changes, changed);
                }
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                this.failed.set(true);
            }
        }
    }

    private static class Stats {
        ByteSequence row = null;
        int seq;
        long sum;
        int[] data = new int[10];

        public Stats(Iterator<Map.Entry<Key, Value>> iterator) {
            while (iterator.hasNext()) {
                Map.Entry<Key, Value> entry = iterator.next();
                if (this.row == null) {
                    this.row = entry.getKey().getRowData();
                }
                String cf = entry.getKey().getColumnFamilyData().toString();
                String cq = entry.getKey().getColumnQualifierData().toString();
                if (cf.equals("data")) {
                    this.data[Integer.parseInt((String)cq)] = Integer.parseInt(entry.getValue().toString());
                    continue;
                }
                if (!cf.equals("meta")) continue;
                if (cq.equals("sum")) {
                    this.sum = Long.parseLong(entry.getValue().toString());
                    continue;
                }
                if (!cq.equals("seq")) continue;
                this.seq = Integer.parseInt(entry.getValue().toString());
            }
            long sum2 = 0L;
            for (int datum : this.data) {
                sum2 += (long)datum;
            }
            Assert.assertEquals((long)sum2, (long)this.sum);
        }

        public Stats(ByteSequence row) {
            this.row = row;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0;
            }
            this.seq = -1;
            this.sum = 0L;
        }

        void set(int index, int value) {
            this.sum -= (long)this.data[index];
            this.sum += (long)value;
            this.data[index] = value;
        }

        ConditionalMutation toMutation() {
            Condition cond = new Condition((CharSequence)"meta", (CharSequence)"seq");
            if (this.seq >= 0) {
                cond.setValue((CharSequence)(this.seq + ""));
            }
            ConditionalMutation cm = new ConditionalMutation(this.row, new Condition[]{cond});
            cm.put((CharSequence)"meta", (CharSequence)"seq", (CharSequence)(this.seq + 1 + ""));
            cm.put((CharSequence)"meta", (CharSequence)"sum", (CharSequence)(this.sum + ""));
            for (int i = 0; i < this.data.length; ++i) {
                cm.put((CharSequence)"data", (CharSequence)(i + ""), (CharSequence)(this.data[i] + ""));
            }
            return cm;
        }

        public String toString() {
            return this.row + " " + this.seq + " " + this.sum;
        }
    }

    public static class MultiplyingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = l * this.amount + "";
            return new Value(newVal.getBytes(StandardCharsets.UTF_8));
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }

    public static class AddingIterator
    extends WrappingIterator {
        long amount = 0L;

        public Value getTopValue() {
            Value val = super.getTopValue();
            long l = Long.parseLong(val.toString());
            String newVal = l + this.amount + "";
            return new Value(newVal.getBytes(StandardCharsets.UTF_8));
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
            this.setSource(source);
            this.amount = Long.parseLong(options.get("amount"));
        }
    }

    private static class Callback
    implements MiniClusterConfigurationCallback {
        private Callback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            Map siteConf = cfg.getSiteConfig();
            siteConf.put(Property.TRACE_SPAN_RECEIVER_PREFIX.getKey() + "tracer.span.min.ms", "0");
            cfg.setSiteConfig(siteConf);
        }
    }
}

