/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanWalIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(CleanWalIT.class);

    @Override
    public int defaultTimeoutSeconds() {
        return 240;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Before
    public void offlineTraceTable() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CleanWalIT.getClientProps()).build();){
            String traceTable = (String)client.instanceOperations().getSystemConfiguration().get(Property.TRACE_TABLE.getKey());
            if (client.tableOperations().exists(traceTable)) {
                client.tableOperations().offline(traceTable, true);
            }
        }
    }

    @After
    public void onlineTraceTable() throws Exception {
        if (cluster != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CleanWalIT.getClientProps()).build();){
                String traceTable = (String)client.instanceOperations().getSystemConfiguration().get(Property.TRACE_TABLE.getKey());
                if (client.tableOperations().exists(traceTable)) {
                    client.tableOperations().online(traceTable, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CleanWalIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            for (String table : new BatchWriter[]{MetadataTable.NAME, RootTable.NAME}) {
                client.tableOperations().flush(table, null, null, true);
            }
            log.debug("Checking entries for {}", (Object)tableName);
            Assert.assertEquals((long)1L, (long)this.count(tableName, client));
            for (String table : new String[]{MetadataTable.NAME, RootTable.NAME}) {
                log.debug("Checking logs for {}", (Object)table);
                Assert.assertEquals((String)("Found logs for " + table), (long)0L, (long)this.countLogs(client));
            }
            bw = client.createBatchWriter(tableName);
            try {
                Mutation m = new Mutation((CharSequence)"row");
                m.putDelete((CharSequence)"cf", (CharSequence)"cq");
                bw.addMutation(m);
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            Assert.assertEquals((long)0L, (long)this.count(tableName, client));
            client.tableOperations().flush(tableName, null, null, true);
            client.tableOperations().flush(MetadataTable.NAME, null, null, true);
            client.tableOperations().flush(RootTable.NAME, null, null, true);
            try {
                CleanWalIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
            finally {
                CleanWalIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
            Assert.assertEquals((long)0L, (long)this.count(tableName, client));
        }
    }

    private int countLogs(AccumuloClient client) throws TableNotFoundException {
        int count = 0;
        try (Scanner scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            scanner.setRange(MetadataSchema.TabletsSection.getRange());
            for (Map.Entry entry : scanner) {
                log.debug("Saw {}={}", entry.getKey(), entry.getValue());
                ++count;
            }
        }
        return count;
    }

    int count(String tableName, AccumuloClient client) throws Exception {
        try (Scanner s = client.createScanner(tableName, Authorizations.EMPTY);){
            int n = Iterators.size((Iterator)s.iterator());
            return n;
        }
    }
}

