/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class BalanceFasterIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(3);
    }

    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    @Test(timeout=90000L)
    public void test() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Iterator i;
            client.tableOperations().create(tableName);
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int i2 = 0; i2 < 1000; ++i2) {
                splits.add(new Text("" + i2));
            }
            client.tableOperations().addSplits(tableName, splits);
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                int total;
                s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                s.setRange(MetadataSchema.TabletsSection.getRange());
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                do {
                    total = 0;
                    counts.clear();
                    for (Map.Entry kv : s) {
                        String host = ((Value)kv.getValue()).toString();
                        if (!counts.containsKey(host)) {
                            counts.put(host, 0);
                        }
                        counts.put(host, (Integer)counts.get(host) + 1);
                        ++total;
                    }
                } while (total <= 1000);
                Assert.assertEquals((long)3L, (long)counts.size());
                i = counts.values().iterator();
            }
            int a = (Integer)i.next();
            int b = (Integer)i.next();
            int c = (Integer)i.next();
            Assert.assertTrue((Math.abs(a - b) < 3 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(a - c) < 3 ? 1 : 0) != 0);
            Assert.assertTrue((a > 330 ? 1 : 0) != 0);
        }
    }
}

