/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import java.io.File;
import java.security.SecureRandom;
import java.util.Properties;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.ClusterUsers;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public abstract class SharedMiniClusterBase
extends AccumuloITBase
implements ClusterUsers {
    private static final Logger log = LoggerFactory.getLogger(SharedMiniClusterBase.class);
    public static final String TRUE = Boolean.toString(true);
    private static String principal = "root";
    private static String rootPassword;
    private static AuthenticationToken token;
    private static MiniAccumuloClusterImpl cluster;
    private static TestingKdc krb;

    public static void startMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(MiniClusterConfigurationCallback.NO_CALLBACK);
    }

    public static void startMiniClusterWithConfig(MiniClusterConfigurationCallback miniClusterCallback) throws Exception {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assert.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        MiniClusterHarness harness = new MiniClusterHarness();
        if (TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"))) {
            krb = new TestingKdc();
            krb.start();
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            ClusterUser rootUser = krb.getRootUser();
            UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            token = new KerberosToken();
        } else {
            rootPassword = "rootPasswordShared1";
            token = new PasswordToken((CharSequence)rootPassword);
        }
        cluster = harness.create(SharedMiniClusterBase.class.getName(), System.currentTimeMillis() + "_" + new SecureRandom().nextInt(Short.MAX_VALUE), token, miniClusterCallback, krb);
        cluster.start();
        if (krb != null) {
            String traceTable = Property.TRACE_TABLE.getDefaultValue();
            ClusterUser systemUser = krb.getAccumuloServerUser();
            ClusterUser rootUser = krb.getRootUser();
            UserGroupInformation.loginUserFromKeytab((String)systemUser.getPrincipal(), (String)systemUser.getKeytab().getAbsolutePath());
            KerberosToken tempToken = new KerberosToken();
            try (AccumuloClient c = cluster.createAccumuloClient(systemUser.getPrincipal(), (AuthenticationToken)tempToken);){
                c.securityOperations().authenticateUser(systemUser.getPrincipal(), (AuthenticationToken)tempToken);
            }
            UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
            c = cluster.createAccumuloClient(principal, token);
            try {
                c.tableOperations().create(traceTable);
                c.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.READ);
                c.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.WRITE);
                c.securityOperations().grantTablePermission(systemUser.getPrincipal(), traceTable, TablePermission.ALTER_TABLE);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    public static void stopMiniCluster() {
        if (cluster != null) {
            try {
                cluster.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop minicluster", (Throwable)e);
            }
        }
        if (krb != null) {
            try {
                krb.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop KDC", (Throwable)e);
            }
        }
    }

    public static String getRootPassword() {
        return rootPassword;
    }

    public static AuthenticationToken getToken() {
        return ClientProperty.getAuthenticationToken((Properties)SharedMiniClusterBase.getClientProps());
    }

    public static String getPrincipal() {
        return ClientProperty.AUTH_PRINCIPAL.getValue(SharedMiniClusterBase.getClientProps());
    }

    public static MiniAccumuloClusterImpl getCluster() {
        return cluster;
    }

    public static File getMiniClusterDir() {
        return cluster.getConfig().getDir();
    }

    public static Properties getClientProps() {
        return SharedMiniClusterBase.getCluster().getClientProperties();
    }

    public static TestingKdc getKdc() {
        return krb;
    }

    public ClusterUser getAdminUser() {
        if (krb == null) {
            return new ClusterUser(SharedMiniClusterBase.getPrincipal(), SharedMiniClusterBase.getRootPassword());
        }
        return krb.getRootUser();
    }

    public ClusterUser getUser(int offset) {
        if (krb == null) {
            String user = SharedMiniClusterBase.class.getName() + "_" + this.testName.getMethodName() + "_" + offset;
            return new ClusterUser(user, user);
        }
        return krb.getClientPrincipal(offset);
    }

    public static ClientInfo getClientInfo() {
        return ClientInfo.from((Properties)cluster.getClientProperties());
    }

    public static boolean saslEnabled() {
        return SharedMiniClusterBase.getClientInfo().saslEnabled();
    }

    public static String getAdminPrincipal() {
        return cluster.getConfig().getRootUserName();
    }
}

