/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.status;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.status.StatusInformation;
import org.apache.accumulo.server.monitor.DedupedLogEvent;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

@Path(value="/status")
@Produces(value={"application/json", "application/xml"})
public class StatusResource {
    @Inject
    private Monitor monitor;

    @GET
    public StatusInformation getTables() {
        Status masterStatus;
        Status gcStatus;
        Status tServerStatus = Status.ERROR;
        MasterMonitorInfo mmi = this.monitor.getMmi();
        if (mmi != null) {
            gcStatus = this.monitor.getGcStatus() != null ? Status.OK : Status.ERROR;
            List masters = this.monitor.getContext().getMasterLocations();
            masterStatus = masters.size() == 0 ? Status.ERROR : Status.OK;
            int tServerUp = mmi.getTServerInfoSize();
            int tServerDown = mmi.getDeadTabletServersSize();
            int tServerBad = mmi.getBadTServersSize();
            if ((tServerDown > 0 || tServerBad > 0) && tServerUp > 0) {
                tServerStatus = Status.WARN;
            } else if ((tServerDown == 0 || tServerBad == 0) && tServerUp > 0) {
                tServerStatus = Status.OK;
            } else if (tServerUp == 0) {
                tServerStatus = Status.ERROR;
            }
        } else {
            masterStatus = Status.ERROR;
            gcStatus = this.monitor.getGcStatus() == null ? Status.ERROR : Status.OK;
            tServerStatus = Status.ERROR;
        }
        List logs = LogService.getInstance().getEvents();
        boolean logsHaveError = false;
        for (DedupedLogEvent dedupedLogEvent : logs) {
            if (!dedupedLogEvent.getEvent().getLevel().isGreaterOrEqual((Priority)Level.ERROR)) continue;
            logsHaveError = true;
            break;
        }
        int numProblems = this.monitor.getProblemSummary().entrySet().size();
        StatusInformation status = new StatusInformation(masterStatus.toString(), gcStatus.toString(), tServerStatus.toString(), logs.size(), logsHaveError, numProblems);
        return status;
    }

    public static enum Status {
        OK,
        ERROR,
        WARN;

    }
}

