/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.statistics;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.monitor.Monitor;

@Path(value="/statistics")
@Produces(value={"application/json", "application/xml"})
public class StatisticsResource {
    @Inject
    private Monitor monitor;

    @GET
    @Path(value="lookupRate")
    public double getLookupRate() {
        return this.monitor.getLookupRate();
    }

    @GET
    @Path(value="totalTables")
    public int getTotalTables() {
        return this.monitor.getTotalTables();
    }

    @GET
    @Path(value="totalTabletCount")
    public int getTotalTabletCount() {
        return this.monitor.getTotalTabletCount();
    }

    @GET
    @Path(value="totalEntries")
    public long getTotalEntries() {
        return this.monitor.getTotalEntries();
    }

    @GET
    @Path(value="totalIngestRate")
    public double getTotalIngestRate() {
        return this.monitor.getTotalIngestRate();
    }

    @GET
    @Path(value="totalQueryRate")
    public double getTotalQueryRate() {
        return this.monitor.getTotalQueryRate();
    }

    @GET
    @Path(value="totalScanRate")
    public double getTotalScanRate() {
        return this.monitor.getTotalScanRate();
    }

    @GET
    @Path(value="totalHoldTime")
    public long getTotalHoldTime() {
        return this.monitor.getTotalHoldTime();
    }

    @GET
    @Path(value="gcStatus")
    public GCStatus getGcStatus() {
        return this.monitor.getGcStatus();
    }

    @GET
    @Path(value="totalLookups")
    public long getTotalLookups() {
        return this.monitor.getTotalLookups();
    }

    @GET
    @Path(value="time/scanRate")
    public List<Pair<Long, Integer>> getScanRate() {
        return this.monitor.getScanRateOverTime();
    }

    @GET
    @Path(value="time/queryRate")
    public List<Pair<Long, Integer>> getQueryRate() {
        return this.monitor.getQueryRateOverTime();
    }

    @GET
    @Path(value="time/scanEntries")
    public List<Pair<String, List<Pair<Long, Integer>>>> getScanEntries() {
        ArrayList<Pair<String, List<Pair<Long, Integer>>>> scanEntries = new ArrayList<Pair<String, List<Pair<Long, Integer>>>>();
        Pair read = new Pair((Object)"Read", this.monitor.getScanRateOverTime());
        Pair returned = new Pair((Object)"Returned", this.monitor.getQueryRateOverTime());
        scanEntries.add(read);
        scanEntries.add(returned);
        return scanEntries;
    }

    @GET
    @Path(value="time/queryByteRate")
    public List<Pair<Long, Double>> getQueryByteRate() {
        return this.monitor.getQueryByteRateOverTime();
    }

    @GET
    @Path(value="time/load")
    public List<Pair<Long, Double>> getLoad() {
        return this.monitor.getLoadOverTime();
    }

    @GET
    @Path(value="time/ingestRate")
    public List<Pair<Long, Double>> getIngestRate() {
        return this.monitor.getIngestRateOverTime();
    }

    @GET
    @Path(value="time/ingestByteRate")
    public List<Pair<Long, Double>> getIngestByteRate() {
        return this.monitor.getIngestByteRateOverTime();
    }

    @GET
    @Path(value="time/minorCompactions")
    public List<Pair<Long, Integer>> getMinorCompactions() {
        return this.monitor.getMinorCompactionsOverTime();
    }

    @GET
    @Path(value="time/majorCompactions")
    public List<Pair<Long, Integer>> getMajorCompactions() {
        return this.monitor.getMajorCompactionsOverTime();
    }

    @GET
    @Path(value="time/lookups")
    public List<Pair<Long, Double>> getLookups() {
        return this.monitor.getLookupsOverTime();
    }

    @GET
    @Path(value="time/indexCacheHitRate")
    public List<Pair<Long, Double>> getIndexCacheHitRate() {
        return this.monitor.getIndexCacheHitRateOverTime();
    }

    @GET
    @Path(value="time/dataCacheHitRate")
    public List<Pair<Long, Double>> getDataCacheHitRate() {
        return this.monitor.getDataCacheHitRateOverTime();
    }
}

