/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.scans;

import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.scans.ScanInformation;
import org.apache.accumulo.monitor.rest.scans.Scans;

@Path(value="/scans")
@Produces(value={"application/json", "application/xml"})
public class ScansResource {
    @Inject
    private Monitor monitor;

    @GET
    public Scans getTables() {
        Scans scans = new Scans();
        MasterMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return scans;
        }
        Map<HostAndPort, Monitor.ScanStats> entry = this.monitor.getScans();
        for (TabletServerStatus tserverInfo : mmi.getTServerInfo()) {
            Monitor.ScanStats stats = entry.get(HostAndPort.fromString((String)tserverInfo.name));
            if (stats == null) continue;
            scans.addScan(new ScanInformation(tserverInfo, stats.scanCount, stats.oldestScan));
        }
        return scans;
    }
}

