/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.gc;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.gc.GarbageCollection;
import org.apache.accumulo.monitor.rest.gc.GarbageCollectorCycle;
import org.apache.accumulo.monitor.rest.gc.GarbageCollectorStatus;

@Path(value="/gc")
@Produces(value={"application/json", "application/xml"})
public class GarbageCollectorResource {
    @Inject
    private Monitor monitor;

    @GET
    public GarbageCollectorStatus getStatus() {
        return new GarbageCollectorStatus(this.monitor.getGcStatus());
    }

    @Path(value="files")
    @GET
    public GarbageCollection getFileStatus() {
        GCStatus gcStatus = this.monitor.getGcStatus();
        if (gcStatus == null) {
            return GarbageCollection.getEmpty();
        }
        return new GarbageCollection(gcStatus.last, gcStatus.current);
    }

    @Path(value="files/last")
    @GET
    public GarbageCollectorCycle getLastCycle() {
        GCStatus status = this.monitor.getGcStatus();
        if (status == null) {
            return GarbageCollectorCycle.getEmpty();
        }
        return new GarbageCollectorCycle(status.last);
    }

    @Path(value="files/current")
    @GET
    public GarbageCollectorCycle getCurrentCycle() {
        GCStatus status = this.monitor.getGcStatus();
        if (status == null) {
            return GarbageCollectorCycle.getEmpty();
        }
        return new GarbageCollectorCycle(status.current);
    }

    @Path(value="wals")
    @GET
    public GarbageCollection getWalStatus() {
        GCStatus gcStatus = this.monitor.getGcStatus();
        if (gcStatus == null) {
            return GarbageCollection.getEmpty();
        }
        return new GarbageCollection(gcStatus.lastLog, gcStatus.currentLog);
    }

    @Path(value="wals/last")
    @GET
    public GarbageCollectorCycle getLastWalCycle() {
        GCStatus status = this.monitor.getGcStatus();
        if (status == null) {
            return GarbageCollectorCycle.getEmpty();
        }
        return new GarbageCollectorCycle(status.lastLog);
    }

    @Path(value="wals/current")
    @GET
    public GarbageCollectorCycle getCurrentWalCycle() {
        GCStatus status = this.monitor.getGcStatus();
        if (status == null) {
            return GarbageCollectorCycle.getEmpty();
        }
        return new GarbageCollectorCycle(status.currentLog);
    }
}

