/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.SummaryInformation;
import org.apache.accumulo.monitor.rest.master.MasterResource;
import org.apache.accumulo.monitor.rest.tables.TablesResource;
import org.apache.accumulo.monitor.rest.tservers.TabletServer;

@Path(value="/")
@Produces(value={"application/json", "application/xml"})
public class XMLResource {
    @Inject
    private Monitor monitor;

    public SummaryInformation getInformation() {
        MasterMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        SummaryInformation xml = new SummaryInformation(mmi.tServerInfo.size(), MasterResource.getTables(this.monitor), TablesResource.getTables(this.monitor));
        for (TabletServerStatus status : mmi.tServerInfo) {
            xml.addTabletServer(new TabletServer(this.monitor, status));
        }
        return xml;
    }

    @GET
    @Path(value="xml")
    @Produces(value={"application/xml"})
    public SummaryInformation getXMLInformation() {
        return this.getInformation();
    }

    @GET
    @Path(value="json")
    @Produces(value={"application/json"})
    public SummaryInformation getJSONInformation() {
        return this.getInformation();
    }
}

