/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.volume;

import org.apache.accumulo.core.volume.Volume;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class NonConfiguredVolume
implements Volume {
    private FileSystem fs;

    public NonConfiguredVolume(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String getBasePath() {
        throw new UnsupportedOperationException("No base path known because this Volume isn't configured in accumulo.properties");
    }

    @Override
    public Path prefixChild(Path p) {
        throw new UnsupportedOperationException("Cannot prefix path because this Volume isn't configured in accumulo.properties");
    }

    @Override
    public Path prefixChild(String p) {
        throw new UnsupportedOperationException("Cannot prefix path because this Volume isn't configured in accumulo.properties");
    }

    @Override
    public boolean isValidPath(Path p) {
        throw new UnsupportedOperationException("Cannot determine if path is valid because this Volume isn't configured in accumulo.properties");
    }

    public boolean equals(Object o) {
        if (o instanceof NonConfiguredVolume) {
            NonConfiguredVolume other = (NonConfiguredVolume)o;
            return this.fs.equals(other.getFileSystem());
        }
        return false;
    }

    public String toString() {
        return "NonConfiguredVolume: " + this.fs;
    }

    public int hashCode() {
        return NonConfiguredVolume.class.hashCode() ^ this.fs.hashCode();
    }
}

