/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.ratelimit;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.accumulo.core.util.ratelimit.GuavaRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedRateLimiterFactory {
    private static final long REPORT_RATE = 60000L;
    private static final long UPDATE_RATE = 1000L;
    private static SharedRateLimiterFactory instance = null;
    private final Logger log = LoggerFactory.getLogger(SharedRateLimiterFactory.class);
    private final WeakHashMap<String, SharedRateLimiter> activeLimiters = new WeakHashMap();

    private SharedRateLimiterFactory() {
    }

    public static synchronized SharedRateLimiterFactory getInstance() {
        if (instance == null) {
            instance = new SharedRateLimiterFactory();
            Timer timer = new Timer("SharedRateLimiterFactory update/report polling");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    instance.update();
                }
            }, 1000L, 1000L);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    instance.report();
                }
            }, 60000L, 60000L);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimiter create(String name, RateProvider rateProvider) {
        WeakHashMap<String, SharedRateLimiter> weakHashMap = this.activeLimiters;
        synchronized (weakHashMap) {
            if (this.activeLimiters.containsKey(name)) {
                return this.activeLimiters.get(name);
            }
            long initialRate = rateProvider.getDesiredRate();
            SharedRateLimiter limiter = new SharedRateLimiter(name, rateProvider, initialRate);
            this.activeLimiters.put(name, limiter);
            return limiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        ImmutableMap limitersCopy;
        WeakHashMap<String, SharedRateLimiter> weakHashMap = this.activeLimiters;
        synchronized (weakHashMap) {
            limitersCopy = ImmutableMap.copyOf(this.activeLimiters);
        }
        for (Map.Entry entry : limitersCopy.entrySet()) {
            try {
                ((SharedRateLimiter)entry.getValue()).update();
            }
            catch (Exception ex) {
                this.log.error(String.format("Failed to update limiter %s", entry.getKey()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void report() {
        ImmutableMap limitersCopy;
        WeakHashMap<String, SharedRateLimiter> weakHashMap = this.activeLimiters;
        synchronized (weakHashMap) {
            limitersCopy = ImmutableMap.copyOf(this.activeLimiters);
        }
        for (Map.Entry entry : limitersCopy.entrySet()) {
            try {
                ((SharedRateLimiter)entry.getValue()).report();
            }
            catch (Exception ex) {
                this.log.error(String.format("Failed to report limiter %s", entry.getKey()), (Throwable)ex);
            }
        }
    }

    protected class SharedRateLimiter
    extends GuavaRateLimiter {
        private volatile long permitsAcquired;
        private volatile long lastUpdate;
        private final RateProvider rateProvider;
        private final String name;

        SharedRateLimiter(String name, RateProvider rateProvider, long initialRate) {
            super(initialRate);
            this.permitsAcquired = 0L;
            this.name = name;
            this.rateProvider = rateProvider;
            this.lastUpdate = System.currentTimeMillis();
        }

        @Override
        public void acquire(long permits) {
            super.acquire(permits);
            this.permitsAcquired += permits;
        }

        public void update() {
            long rate = this.rateProvider.getDesiredRate();
            if (rate != this.getRate()) {
                this.setRate(rate);
            }
        }

        public void report() {
            if (SharedRateLimiterFactory.this.log.isDebugEnabled()) {
                long duration = System.currentTimeMillis() - this.lastUpdate;
                if (duration == 0L) {
                    return;
                }
                this.lastUpdate = System.currentTimeMillis();
                long sum = this.permitsAcquired;
                this.permitsAcquired = 0L;
                if (sum > 0L) {
                    SharedRateLimiterFactory.this.log.debug(String.format("RateLimiter '%s': %,d of %,d permits/second", this.name, sum * 1000L / duration, this.getRate()));
                }
            }
        }
    }

    public static interface RateProvider {
        public long getDesiredRate();
    }
}

