/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.OptionalInt;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.util.AccumuloUncaughtExceptionHandler;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(NamingThreadFactory.class);
    private static final Thread.UncaughtExceptionHandler UEH = new AccumuloUncaughtExceptionHandler();
    private AtomicInteger threadNum = new AtomicInteger(1);
    private String name;
    private OptionalInt priority;

    public NamingThreadFactory(String name) {
        this.name = name;
        this.priority = OptionalInt.empty();
    }

    public NamingThreadFactory(String name, OptionalInt priority) {
        this.name = name;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Daemon thread = new Daemon(new LoggingRunnable(log, r), this.name + " " + this.threadNum.getAndIncrement());
        thread.setUncaughtExceptionHandler(UEH);
        if (this.priority.isPresent()) {
            thread.setPriority(this.priority.getAsInt());
        }
        return thread;
    }
}

